Ext.onReady(P0045extOnReady)
function P0045extOnReady()
{
	ImportCssForFrame('fileuploadfield');
	
	if (activityId.indexOf('cargotec_proces_eo_eo_request')>=0 ) //|| activityId.indexOf('555cargotec_proces_eo_delegate_sourcing')>=0)
	{
		ModifyFormForLocalization();
	}
	
	if (activityId.indexOf('proces_eo_delegate_logistics')>=0 || activityId.indexOf('proces_eo_consultation1')>=0 || activityId.indexOf('delegate_sourcing')>=0) 
	{
		setTimeout("changeButtonsEO()",10);
	}
}

function changeButtonsEO()
{
	// nadpisuje przyciski w celu zweryfikowania zmian w processdata
	// ukrywam przycisk SAVE
	try
	{
		document.getElementById('saveBtn').hide();
	}
	catch(ex)
	{
		document.getElementById('saveBtn').onclick = function() {alert( 'Unsupported for this process')};
	}
	
	// przycisk konsultacji na wszystkich etpach
	var consultBttn = P0045_getSubmitButton( "Consult" ); //Send to Logistics //Answer
	if ( consultBttn != null ) 
	{
		consultBttn.onclick = function() { chcekIfUnprocessed('Consult')};
	}	
	
	if(activityId.indexOf('delegate_sourcing')>=0)
	{
		// nadpisuje przycisk akceptacji, konsultacji oraz zapisz
		var subButton = P0045_getSubmitButton( "Send to Sourcing" ); //Send to Logistics //Answer
		if ( subButton != null ) 
		{
			subButton.onclick = function() {chcekIfUnprocessed( 'Send to Sourcing')};
		}				

	}
	else if(activityId.indexOf('delegate_logistics')>=0)
	{
		// nadpisuje przycisk akceptacji
		var subButton = P0045_getSubmitButton( "Send to Logistics" ); //Send to Logistics //Answer
		if ( subButton != null ) 
		{
			subButton.onclick = function() {chcekIfUnprocessed( 'Send to Logistics')};
		}			
	}
	else
	{
		// nadpisuje przycisk odpowiedz, konsultacji oraz zapisz
		var subButton = P0045_getSubmitButton( "Answer" ); //Send to Logistics //Answer
		if ( subButton != null ) 
		{
			subButton.onclick = function() {chcekIfUnprocessed( 'Answer')};
		}	
	}
}

// jesli dane procesu są aktualne i proces nie jestaktualnie przeywarzany przez podprocesy to wywolujemy walidacje jesli jest okreslona 
function chcekIfUnprocessed(bttnName)
{
	bSaveForm = false;
	showLoadingMask(sValidationLoadinMaskId, 'Trwa walidacja danych' ); 
	
	var item_status = document.getElementById('item_status');
	var item_status_new = checkProcessAvaliability('item_status', processId);
	
	if(item_status_new.indexOf('error')==0)
	{
		// wystapil blad
		if(item_status_new.indexOf('processed')>0)
		{
			alert('The tasks data is currently updated by onother process. Please ty again later.');
			removeLoadingMask(sValidationLoadinMaskId);
			return false;
		}
		else
		{
			alert('An error occured. Please contatc the administrator.');
			removeLoadingMask(sValidationLoadinMaskId);
			return false;
		}
	}
	else if(item_status!=undefined && item_status_new!=item_status.value)
	{
		alert('The tasks data has been updated. Please refresh the form.');
		removeLoadingMask(sValidationLoadinMaskId);
//		document.getElementById('item_status').value=item_status_new;
//		document.getElementById('saveBtn').onclick();
		return false;
		
	}
	
	checkValidatorForBttn(bttnName)

	removeLoadingMask(sValidationLoadinMaskId);
}

function checkValidatorForBttn(bttnName)
{
	if(bttnName=='Consult')
	{
		if(authorizeUser(true) && eoConsultationConsult())
		{	
			document.taskForm.action='AcceptActivity.do?actionName=consult';
			submitTaskForm(); 
		}			
	}
	else if(activityId.indexOf('delegate_sourcing')>=0)
	{			
		if(authorizeUser(true) && Delegate_sourcing_Send_to_sourcing())
		{			
			document.taskForm.action='AcceptActivity.do?actionName=send_to_sourcing';
			submitTaskForm(); 
		}		
	}
	else if(activityId.indexOf('delegate_logistics')>=0)
	{			
		if(authorizeUser(true) && Delegate_logistics_Send_to_logistics())
		{			
			document.taskForm.action='AcceptActivity.do?actionName=send_to_logistics';
			submitTaskForm(); 
		}		
	}
	else
	{
	 if(bttnName=='Answer')
		{
			if(authorizeUser(true) && eoConsultationAnswer())
			{	
				document.taskForm.action='AcceptActivity.do?actionName=answer';
				submitTaskForm(); 
			}
			
		}
	}		
}

function P0045_getSubmitButton( name ) {
	var inputs = document.getElementsByTagName( 'input' );
	for ( var i = 0; i < inputs.length; ++i ) {
		if ( inputs[ i ].type === 'button' && inputs[ i ].value === name ) {
			return inputs[ i ];
		}
	}
	return null;
}

function checkProcessAvaliability(variable, givenProcessid){

	if(givenProcessid==undefined)
	{
		givenProcessid=processId;
	}
	var sServletName = 'P0045.eo.ChechProcessAvaliability.customServlet';
	var arg = 'process=' + givenProcessid +"&varid="+variable;
	var result = executeServlet(sServletName,arg);

	return result;
	
}

function ImportCssForFrame(cssName) 
{ 	
	if (!document.getElementById(cssName)) 
	{   
		var head = document.getElementsByTagName('head')[0];
		var link = document.createElement('link');
		link.id  = cssName;
		link.rel = 'stylesheet';
		link.type = 'text/css';
		link.href = 'style/fileuploadfield.css';
		link.media = 'all';
		head.appendChild(link);
	} 
}

function P0045eoKolorowanieLinii(oEditorGridPanel)
{
	//ZMIANA 2014-11-25 Zmiany dla lokalizacji	
//	if(oEditorGridPanel.store.getCount()<10)
//		oEditorGridPanel.autoHeight = true;	
	var process_type = clientGetRadioValue('process_type');
	
	if(activityId.indexOf('cargotec_proces_eo_delegate_sourcing')>=0 && process_type!=undefined && process_type!='Localization')
	{
		oEditorGridPanel.onRefresh(null, null, oEditorGridPanel, null);
	}
	
	var view = oEditorGridPanel.getView();
	var store = oEditorGridPanel.getStore();
	var iloscWierszy = store.getCount();
	if (activityId.indexOf('calculate_cost_price')>=0)
	{
		for (var q=0;q<iloscWierszy; q++)
		{
			var wiersz = store.getAt(q);
			var new_price = wiersz.get('new_price');
			if (new_price=="Yes")
			{
				view.addRowClass(q, 'eo_item_new_price');
			}
		}
		var title = "Items&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #D1FFB1; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - items with new price &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #FFFFFF; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - other items";
		oEditorGridPanel.setTitle(title);
		
	} //end_if
	else
	{
		for (var q=0;q<iloscWierszy; q++)
		{
			var wiersz = store.getAt(q);
			try
			{
				var item_status = wiersz.get('item_status');
				var critical_item = wiersz.get('critical_item');
				if(item_status!=undefined && item_status.indexOf('rejected') > 0 )
				{
					view.addRowClass(q, 'eo_item_rejected');
				}						
				else if (critical_item!=undefined && critical_item=="Yes")
				{
					view.addRowClass(q, 'eo_item_critical');
				}
												
				if(activityId.indexOf('delegate_priorities')>=0 )
				{					
					var type_of_purchase = wiersz.get('type_of_purchase');
					var logistic_needed = wiersz.get('logistic_needed');
					var new_item = wiersz.get('new_item');			
					
					if (!(type_of_purchase=='Purchase' && (logistic_needed=='Yes' || new_item=='Yes')) )
					{	
						view.addRowClass(q, 'eo_item_inactive');
					}
				}
			}
			catch(ex)
			{
				
			}
		}
		var title = "Items&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #FF99CC; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - Critical items &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #FFFFFF; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - other items";
		
		oEditorGridPanel.setTitle(title);
	} //end_else
	
	if(activityId.indexOf('cargotec_proces_eo_delegate_sourcing')>=0 && process_type!=undefined && process_type=='Localization')
	{
		var varToHideList = new Array();
		
		varToHideList[varToHideList.length]='eo_number';
		varToHideList[varToHideList.length]='eo_class';
		varToHideList[varToHideList.length]='eo_class_desc';
		
		if( varToHideList.length > 0 ){
			clientHideVar(varToHideList, null);
		}				    
	    var columnToHide = new Array();		
	    columnToHide[columnToHide.length]='old_item_no';
	    columnToHide[columnToHide.length]='belongs_to';		
	    columnToHide[columnToHide.length]='new_item';
		columnToHide[columnToHide.length]='type_of_purchase';
	    columnToHide[columnToHide.length]='obsolete';
	    columnToHide[columnToHide.length]='new_amount';
	    columnToHide[columnToHide.length]='sourcing_needed';		
	    columnToHide[columnToHide.length]='logistic_needed';
	    
	    clientHideColumns(oEditorGridPanel, columnToHide);	
	}
	
	if(activityId.indexOf('consultation')>=0)
	{	
		oEditorGridPanel.keys=null;
		oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
		oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
		oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
	}
	
}

function Eo_request_Send()
{
	var czyOk = eoCheckTableRequirements('request');
	if (czyOk == false)
		return false;
	
	czyOk = eoCheckPOTable();
	if (czyOk ==false)
		return false;
	
	//sprawdzenie dodtakowych pol
	if(document.getElementById('process_type')!=undefined)
	{
		
		var process_type = clientGetRadioValue('process_type');
	
		if(process_type!='Localization')
		{
			//sprawdzam wymagane pola
			var eo_number = document.getElementById('eo_number').value;
			if(eo_number=='')
			{
				alert("Please complete the required index named EO number");
				return false;
			}
			
			var eo_class = document.getElementById('eo_class').value;
			if(eo_class=='')
			{
				alert("Please complete the required index named Class");
				return false;
			}
						
			var eo_class_desc = document.getElementById('eo_class_desc').value;
			if(eo_class_desc=='')
			{
				alert("Please complete the required index named Class desc");
				return false;
			}			
		}
	}
	return true;
}

function Delegate_sourcing_Back_to_requestor()
{
	var commentAdd = checkChangesInComments(activityId,processId,sTaskUserName);
	if (commentAdd=="FALSE")
	{
		alert("You must add a comment before taking this action.");
		return false;
	}
	return true;
}

function Delegate_sourcing_Send_to_sourcing()
{
	var czyOk = eoCheckTableRequirements('delegate_sourcing');
	if (czyOk == false)
		return false;
	
	return true;
}


function Sourcing_Confirm()
{
	var czyOk = eoCheckTableRequirements('sourcing');
	if (czyOk == false)
	{
		return false;
	}
	
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = tabela.getCount();
	var newAssignments = "";
	for (var z=0;z<iloscLinii;z++)
	{
		var wiersz = tabela.getAt(z);
		var odpowiedzialny = wiersz.get('responsible_sourcing_login');
		var changeAvailibility = wiersz.get('change_availibility');
		var newPrice = wiersz.get('new_price');
		var vendorNo = wiersz.get('vendor_no');
		var vendorName = wiersz.get('vendor_name');
		var responsibleSourcing = wiersz.get('responsible_sourcing');
		var itemStatusSourcing = wiersz.get('item_status_sourcing');
		var availibilityDate = wiersz.get('availibility_date');
		var leadTime = wiersz.get('lead_time');
		var obsolete = wiersz.get('obsolete');
		var obsolete_value_at_sup = wiersz.get('obsolete_value_at_sup');
		var stockAtSupplier = wiersz.get('stock_at_supplier');
		var stockValueAtSupplier = wiersz.get('stock_value_at_supplier');

		if (odpowiedzialny==userAssignedToTask)
			continue;
		else if (changeAvailibility=="" || (changeAvailibility=="Date" && availibilityDate=="" && leadTime=="") || (obsolete=="Yes" && obsolete_value_at_sup==="") || newPrice=="" || vendorNo=="" || vendorName=="" || responsibleSourcing==""  || stockAtSupplier==="" || stockValueAtSupplier==="")
		{
			if (newAssignments=="")
				newAssignments=odpowiedzialny;
			else
				newAssignments+=";"+odpowiedzialny;
		} //end_else
	}
	
	document.getElementById('sourcing_assignments').value=newAssignments;
	
	return true;
}

function Eo_request_change_Send()
{
	var czyOk = eoCheckTableRequirements('request_change');
	if (czyOk == false)
		return false;
	
	return true;
}

function Delegate_logistics_Send_to_logistics()
{
	var czyOk = eoCheckTableRequirements('delegate_logistic');
	if (czyOk == false)
		return false;
	
	czyOk = eoCheckPOTable();
	if (czyOk ==false)
		return false;
	
	return true;
}

function Logistics_Confirm()
{
	var czyOk = eoCheckTableRequirements('logistic');
	if (czyOk == false)
		return false;
	
	czyOk = eoCheckPOTable();
	if (czyOk ==false)
		return false;
	
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = tabela.getCount();
	var newAssignments = "";
	for (var z=0;z<iloscLinii;z++)
	{
		var wiersz = tabela.getAt(z);
		var odpowiedzialny = wiersz.get('responsible_logistics_login');
		
		var obsolete = wiersz.get('obsolete');
		var obsoleteValue = wiersz.get('obsolete_value');
		var responsibleLogistics = wiersz.get('responsible_logistics');
		var stockInMau = wiersz.get('stock_in_mau');
		var stockValueInMau = wiersz.get('stock_value_in_mau');
		var stockEndDate = wiersz.get('stock_end_date');
		var proposal = wiersz.get('proposal');

		if (odpowiedzialny==userAssignedToTask)
			continue;
		else if (responsibleLogistics=="" || (obsolete=="Yes" && obsoleteValue==="") || stockInMau==="" || stockValueInMau==="" || stockEndDate=="" || proposal=="")
		{
			if (newAssignments=="")
				newAssignments=odpowiedzialny;
			else
				newAssignments+=";"+odpowiedzialny;
		} //end_else
	}
	
	document.getElementById('logistic_assignments').value=newAssignments;

	return true;
}

function Update_control_plans_Confirm()
{
	return confirm("Akceptacja tego zadania oznacza, że zrewidowane zostały check listy oraz plany kontroli.");
}

function Calculate_cost_price_Confirm()
{
	return confirm("Akceptacja tego zadania oznacza, że dokonano aktualizacji ceny dla każdego itemu w LN.");
}

function Estimate_costs_Confirm()
{
	var czyOk = eoCheckTableRequirements('estimate_before');
	if (czyOk == false)
		return false;
	
	czyOk = eoCheckPOTable();
	if (czyOk ==false)
		return false;
	
	return true;
}

function Estimate_costs_after_scrap_and_rework_Confirm()
{
	var czyOk = eoCheckTableRequirements('estimate_after');
	if (czyOk == false)
		return false;
	
	czyOk = eoCheckPOTable();
	if (czyOk ==false)
		return false;
	
	return true;
}

function Confirm_implementation_Change_implementation_date()
{
	//data implementacji musi być późniejsza niż obecna
	var implementationDate = document.getElementById('implementation_date').value;
	if (implementationDate=="")
	{
		alert("Please fill up 'Implementation date'.");
		return false;
	}
	
	czyOk = eoCheckPOTable();
	if (czyOk ==false)
		return false;
	
	var dateImplement = Date.parseDate(implementationDate.replace("/","-"),"Y-m-d");
	var dateCurrent = new Date();
	var year = ""+dateCurrent.getFullYear();
	var month = ""+(dateCurrent.getMonth()+1);
	var day = ""+dateCurrent.getDate();
	if (month.length==1)
		month="0"+month;
	if (day.length==1)
		day = "0"+day;
	var sDateCurrent = year+"-"+month+"-"+day;
	dateCurrent = Date.parseDate(sDateCurrent,"Y-m-d");
	if (dateImplement.getTime()<dateCurrent.getTime())
	{
		alert("Implementation date cannot be in the past.");
		return false;
	}
	return true;
}

function Confirm_implementation_Confirm_implementation()
{
	return true;
}

function eoCheckTableRequirements(etap)
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = tabela.getCount();
	if (iloscLinii==0)
	{
		alert("Please fill up at least one row in Items table.");
		return false;
	}

	var check_newItemNo = false;
	var check_oldItemNo = false;
	var check_itemName = false;
	var check_newItem = false;
	var check_typeOfPurchase = false;
	var check_obsolete = false;
	var check_part_type = false;
	var check_desc = false;
	var check_productGroup = false;
	var check_newAmount = false;
	var check_revision = false;
	var check_itemStatus = false;
	var check_newPrice = false;
	var check_changeAvailibility = false;
	var check_availibilityDate = false;
	var check_vendorNo = false;
	var check_vendorName = false;
	var check_responsibleSourcing = false;
	var check_responsibleLogistics = false;
	var check_stockInMau = false;
	var check_stockValueInMau = false;
	var check_stockAtSupplier = false;
	var check_stockValueAtSupplier = false;
	var check_obsoleteValue = false;
	var check_obsoleteValueAtSup = false;
	var check_stockEndDate = false;
	var check_proposal = false;
	var check_decision = false;
	var check_itemStatusSourcing = false;
	var check_sourcingNeeded = false;
	var check_belongsTo = false;
	var check_influence = false;
	var check_influenceDesc = false;
	var check_logisticNeeded = false;
	var check_leadTime = false;
	var check_sdNeeded = false;
	var responsibleColumn;
	
	//ustawienie wymagalności pól
	if (etap=="request")
	{
		check_newItemNo = true;
		check_oldItemNo = false;
		check_itemName = false;
		check_newItem = true;
		check_typeOfPurchase = true;
		check_part_type = true;
		check_desc = false;
		check_productGroup = true;
		check_revision = false;
		check_sourcingNeeded = true;
		check_belongsTo = true;
		check_logisticNeeded = true;
	}
	else if (etap=="request_change")
	{
		check_newItemNo = true;
		check_oldItemNo = false;
		check_itemName = false;
		check_newItem = true;
		check_typeOfPurchase = true;
		check_obsolete = true;
		check_part_type = true;
		check_desc = false;
		check_productGroup = true;
		check_newAmount = false;
		check_revision = false;
	}
	else if (etap=="delegate_sourcing")
	{
		check_responsibleSourcing = true;
	}
	else if (etap=="sourcing")
	{
		check_newPrice = true;
		check_changeAvailibility = true;
		check_vendorNo = true;
		check_vendorName = true;
		check_responsibleSourcing = true;
		check_itemStatusSourcing = false;
		check_obsoleteValueAtSup = true;
		check_leadTime = true;
		check_stockAtSupplier = true;
		check_stockValueAtSupplier = true;
		responsibleColumn="responsible_sourcing_login";
	}
	else if (etap=="delegate_logistic")
	{
		check_responsibleLogistics = true;
	}
	else if (etap=="logistic")
	{
		check_responsibleLogistics = true;
		check_stockInMau = true;
		check_stockValueInMau = true;
		check_stockEndDate = false;
		check_obsoleteValue = true;
		check_proposal = true;
		responsibleColumn="responsible_logistics_login";
		check_influence = true;
		check_influenceDesc = true;
	}
	else if (etap=="estimate_before")
	{
		check_decision = true;
	}
	else if (etap=="estimate_after")
	{
		
	}
	
	//ZMIANA: jesli jest to proces lokalizacji to czyszczę wymagalność niektorych pol
	var process_type = clientGetRadioValue('process_type');
	if(process_type!=undefined && process_type=='Localization')
	{
		check_newItemNo = true;
		check_oldItemNo = false;
		check_itemName = true;
		check_newItem = false;
		check_typeOfPurchase = false;
		check_obsolete = false;
		check_part_type = false;
		check_desc = false;
		check_productGroup = true;
		check_newAmount = false;
		check_revision = false;
	}
	
	var nowaMapa = false;
	if(document.getElementById("critical_item")!= undefined)
	{
		nowaMapa = true;
	}
	
	for (var i=0;i<iloscLinii;i++)
	{
		var wiersz = tabela.getAt(i);
		var responsible;
		if (responsibleColumn!=null)
			responsible = wiersz.get(responsibleColumn);
		var newItemNo = wiersz.get('new_item_no');
		if (check_newItemNo && (newItemNo==null || newItemNo==""))
		{
			alert("Please fill up 'Item no' column in line "+(i+1));
			return false;
		}
		var oldItemNo = wiersz.get('old_item_no');
		if (check_oldItemNo && (oldItemNo==null || oldItemNo==""))
		{
			alert("Please fill up 'Old item no' column in line "+(i+1));
			return false;
		}
		var itemName = wiersz.get('item_name');
		if (check_itemName && (itemName==null || itemName==""))
		{
			alert("Please fill up 'Item name' column in line "+(i+1));
			return false;
		}
		var newItem = wiersz.get('new_item');
		if (check_newItem && (newItem==null || newItem==""))
		{
			alert("Please fill up 'New item' column in line "+(i+1));
			return false;
		}
		var typeOfPurchase = wiersz.get('type_of_purchase');
		if (check_typeOfPurchase && (typeOfPurchase==null || typeOfPurchase==""))
		{
			alert("Please fill up 'Type of purchase' column in line "+(i+1));
			return false;
		}
		var obsolete = wiersz.get('obsolete');
		if (check_obsolete && (obsolete==null || obsolete==""))
		{
			alert("Please fill up 'To be obsolete' column in line "+(i+1));
			return false;
		}
		var part_type = wiersz.get('part_type');
		if (check_part_type && (part_type==null || part_type==""))
		{
			alert("Please fill up 'Part type' column in line "+(i+1));
			return false;
		}
		var desc = wiersz.get('item_desc');
		if (check_desc && (desc==null || desc==""))
		{
			alert("Please fill up 'Description' column in line "+(i+1));
			return false;
		}
		var productGroup = wiersz.get('product_group');
		if (check_productGroup && (productGroup==null || productGroup==""))
		{
			alert("Please fill up 'Product group' column in line "+(i+1));
			return false;
		}
		var newAmount = wiersz.get('new_amount');
		if (check_newAmount && (newAmount==null || newAmount==""))
		{
			alert("Please fill up 'New amount' column in line "+(i+1));
			return false;
		}
		var revision = wiersz.get('revision');
		if (check_revision && (revision==null || revision==""))
		{
			alert("Please fill up 'Revision' column in line "+(i+1));
			return false;
		}
		var sourcingNeeded = wiersz.get('sourcing_needed');
		if (check_sourcingNeeded && (sourcingNeeded==null || sourcingNeeded==""))
		{
			alert("Please fill up 'Sourcing needed' column in line "+(i+1));
			return false;
		}
		var logisticNeeded = wiersz.get('logistic_needed');
		if (check_logisticNeeded && (logisticNeeded==null || logisticNeeded==""))
		{
			alert("Please fill up 'Logistic needed' column in line "+(i+1));
			return false;
		}
		var belongsTo = wiersz.get('belongs_to');
		if (check_belongsTo && (belongsTo==null || belongsTo=="") && typeOfPurchase=='Purchase below') //WYMAGALNOŚĆ WARUNKOWA
		{
			alert("Please fill up 'Belongs to' column in line "+(i+1));
			return false;
		}
		
		var itemStatus = wiersz.get('item_status');
		//dane wymagalne tylko dla itemów innych niż nowe
		if (newItem!="Yes" )
		{		
			if (check_itemStatus && (itemStatus==null || itemStatus==""))
			{
				alert("Please fill up 'Item status' column in line "+(i+1));
				return false;
			}
			var newPrice = wiersz.get('new_price');
			if (check_newPrice && (newPrice==null || newPrice=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'New price' column in line "+(i+1));
				return false;
			}
			var changeAvailibility = wiersz.get('change_availibility');
			if (check_changeAvailibility && (changeAvailibility==null || changeAvailibility=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Change availibility' column in line "+(i+1));
				return false;
			}
			var availibilityDate = wiersz.get('availibility_date');
			var leadTime = wiersz.get('lead_time');
			if (changeAvailibility=="Date" && (availibilityDate=="" || availibilityDate==null) && (leadTime==null || leadTime=="") && responsible==userAssignedToTask) //WYMAGALNOŚĆ WARUNKOWA
			{
				alert("Please fill up 'Availibility date' or 'Lead Time' column in line "+(i+1));
				return false;
			}
			var vendorNo = wiersz.get('vendor_no');
			if (check_vendorNo && (vendorNo==null || vendorNo=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Vendor no' column in line "+(i+1));
				return false;
			}
			var vendorName = wiersz.get('vendor_name');
			if (check_vendorName && (vendorName==null || vendorName=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Vendor name' column in line "+(i+1));
				return false;
			}
			var responsibleSourcing = wiersz.get('responsible_sourcing');
			var sourcingNeeded = wiersz.get('sourcing_needed');
			if (check_responsibleSourcing && (responsibleSourcing==null || responsibleSourcing=="") && sourcingNeeded == "Yes")
			{
				alert("Please fill up 'Responsible - Sourcing' column in line "+(i+1));
				return false;
			}
			var responsibleLogistics = wiersz.get('responsible_logistics');
			if (check_responsibleLogistics && (responsibleLogistics==null || responsibleLogistics=="") && logisticNeeded == "Yes")
			{
				// jesli nowa mapka to sprawdzam czy juz mozna przypisac os odpowiedzialna
				if(nowaMapa==true)
				{
					// linia nie jest odrzucona 
					if(itemStatus=='Delegate logistics')
					{
						// jesli nie ma sourcingu ani lokalizacji to wymagane uzupelnienie
						alert("Please fill up 'Responsible - Logistics' column in line "+(i+1));
						return false;										
					}					
				}
				else
				{
					alert("Please fill up 'Responsible - Logistics' column in line "+(i+1));
					return false;
				}
			}
			var stockInMau = wiersz.get('stock_in_mau');
			if (check_stockInMau && (stockInMau==null || stockInMau==="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Stock in MAU' column in line "+(i+1));
				return false;
			}
			var stockValueInMau = wiersz.get('stock_value_in_mau');
			if (check_stockValueInMau && (stockValueInMau==null || stockValueInMau==="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Stock value in MAU' column in line "+(i+1));
				return false;
			}
			var stockAtSupplier = wiersz.get('stock_at_supplier');
			if (check_stockAtSupplier && (stockAtSupplier==="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Stock at supplier' column in line "+(i+1));
				return false;
			}
			var stockValueAtSupplier = wiersz.get('stock_value_at_supplier');
			if (check_stockValueAtSupplier && (stockValueAtSupplier==="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Stock value at supplier' column in line "+(i+1));
				return false;
			}
			var obsoleteValue = wiersz.get('obsolete_value');
			if (check_obsoleteValue==true && obsolete=="Yes" && (obsoleteValue==null || obsoleteValue==="") && responsible==userAssignedToTask) //WYMAGALNOŚĆ WARUNKOWA
			{
				alert("Please fill up 'Obsolete value at MAU (PLN)' column in line "+(i+1));
				return false;
			}
			var obsoleteValueAtSup = wiersz.get('obsolete_value_at_sup');
			if (check_obsoleteValueAtSup==true && obsolete=="Yes" && (obsoleteValueAtSup==null || obsoleteValueAtSup==="") && responsible==userAssignedToTask) //WYMAGALNOŚĆ WARUNKOWA
			{
				alert("Please fill up 'Obsolete value at Sup.' column in line "+(i+1));
				return false;
			}
			var stockEndDate = wiersz.get('stock_end_date');
			if (check_stockEndDate && (stockEndDate==null || stockEndDate=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Stock end date' column in line "+(i+1));
				return false;
			}
			var influence = wiersz.get('influence_on_project');
			if (check_influence && (influence==null || influence=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Influence on project' column in line "+(i+1));
				return false;
			}
			var influenceDesc = wiersz.get('influence_desc');
			if (check_influenceDesc==true && influence!="No" && (influenceDesc==null || influenceDesc=="") && responsible==userAssignedToTask) //WYMAGALNOŚĆ WARUNKOWA
			{
				alert("Please fill up 'Influence description' column in line "+(i+1));
				return false;
			}
			var proposal = wiersz.get('proposal');
			if (check_proposal && (proposal==null || proposal=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Proposal' column in line "+(i+1));
				return false;
			}
			var decision = wiersz.get('decision');
			if (check_decision && (decision==null || decision==""))
			{
				alert("Please fill up 'Decision' column in line "+(i+1));
				return false;
			}
			var itemStatusSourcing = wiersz.get('item_status_sourcing');
			if (check_itemStatusSourcing && (itemStatusSourcing==null || itemStatusSourcing=="") && responsible==userAssignedToTask)
			{
				alert("Please fill up 'Item status - Sourcing' column in line "+(i+1));
				return false;
			}
			var sdNeeded = wiersz.get('sd_needed');
			var product_line = document.getElementById('product_line').value;
			if (check_sdNeeded && (sdNeeded==="") && product_line=='Port Cranes')
			{
				alert("Please fill up 'SD needed' column in line "+(i+1));
				return false;
			}
		} //end_if
		else
		{
//			// sprawdzam czy nowa mapka
//			if(document.getElementById('process_type')!=undefined || etap=="sourcing")
//			{
				//nowa mapka zaimplementowano lokalizacje
				var responsibleSourcing = wiersz.get('responsible_sourcing');
				var sourcingNeeded = wiersz.get('sourcing_needed');
				if (check_responsibleSourcing && (responsibleSourcing==null || responsibleSourcing==""))
				{
					alert("Please fill up 'Responsible - Sourcing' column in line "+(i+1));
					return false;
				}
				// linia nie jest odrzucona 
				if(itemStatus=='Delegate logistics')
				{
					var responsibleLogistics = wiersz.get('responsible_logistics');
					if (check_responsibleLogistics && (responsibleLogistics==null || responsibleLogistics=="") && logisticNeeded == "Yes")
					{
						alert("Please fill up 'Responsible - Logistics' column in line "+(i+1));
						return false;
					}
				}
//			}
//			else
//			{
//				alert("Localization process is not implemented yet.\nPlease change column <New item> to 'No'. You can write a note that item needs localization in column 'Description'.");
//				return false;
//			}
		}
		
	} //end_for
	
	return true;
}

function eoBeforeRender(oEditorGridPanel)
{
	oEditorGridPanel.keys=null;
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
}

function eoBeforeEdit(obj)
{
	var newItem = obj.record.get("new_item");
	if (newItem=="Yes")
	{
		//zmiana dla lokalizacji
		//jesli nowa mapka to zarowno wymagane jest uzupelnienie sourcing_needed
		var process_type = clientGetRadioValue('process_type');
		if(process_type!=undefined )
		{
		
		}
		else
			obj.cancel=true;
	}
	else if (processId.indexOf('proces_eo')>0)
	{
		if (activityId.indexOf('delegate_sourcing')>0)
		{
			if (obj.record.get('sourcing_needed')=="No")
			{
				alert("Sourcing is not needed for this part type");
				obj.cancel=true;
			}
		}
		else if (activityId.indexOf('delegate_logistics')>0)
		{
			if(obj.record.get('logistic_needed')=="No")
			{
				alert("Logistic is not needed for this part type");
				obj.cancel=true;
			}
		}
		else if(activityId.indexOf('delegate_priorities')>=0 )
		{					
			var type_of_purchase = obj.record.get('type_of_purchase');
			var logistic_needed = obj.record.get('logistic_needed');
			var new_item = obj.record.get('new_item');			
			
			if (!(type_of_purchase=='Purchase' && (logistic_needed=='Yes' || new_item=='Yes')) )
			{	
				alert("Logistic is not needed for this part type");
				obj.cancel=true;
			}
		}
	} //end_if
	else if (processId.indexOf('sub_sour')>0 && activityId.indexOf('sourcing')>0)
	{
		if (obj.field!="responsible_sourcing")
		{
			if (userAssignedToTask!=obj.record.get("responsible_sourcing_login"))
				obj.cancel=true;
		} //end_if
	} //end_if
	else if (processId.indexOf('sub_logi')>0 && activityId.indexOf('logistics')>0)
	{
		if (obj.field!="responsible_logistics")
		{
			if (userAssignedToTask!=obj.record.get("responsible_logistics_login"))
				obj.cancel=true;
		} //end_if
	} //end_if
}

var userAssignedToTask;
function oeGetUserAssignedToTask(oStore)
{
	var czyJestWTabeli=false;
	var activityId = document.getElementsByName('activityId')[0].value;
	for (var i=0;i<oStore.getCount();i++)
	{
		var login = null;
		var statusLinii = null;
		if (activityId.indexOf("sub_sour_sourcing")>0)
		{
			login = oStore.getAt(i).get('responsible_sourcing_login');
			if (login==sTaskUserName)
			{
				czyJestWTabeli=true;
				break;
			}
		}
		else if (activityId.indexOf("sub_logi_logistics")>0)
		{
			var login = oStore.getAt(i).get('responsible_logistics_login');
			if (login==sTaskUserName)
			{
				czyJestWTabeli=true;
				break;
			}
		}
	}
	if (czyJestWTabeli==true)
	{
		userAssignedToTask=sTaskUserName;
	}
	else
	{
		//wykonanie servletu sprawdzającego za kogo jest wykonywane zadanie
		var sActivityId = document.getElementsByName('activityId')[0].value;
		var sServletName="P0045.eo.P0045GetDelegation.customServlet";
		var arg="param="+sTaskUserName+"&param1="+sActivityId;
		var zwrotka = ServletExecution(sServletName,arg);
		var item = zwrotka.getElementsByTagName('item');
		var wynik = item[0].getElementsByTagName('value')[0].firstChild.data;
		if (wynik=="ERROR")
		{
			alert("Wystąpił problem podczas otwierania zadania. Spróbuj wejść w zadanie ponownie.");
		}
		else
		{
			userAssignedToTask=wynik;
		}
	}
}

/* Funkcja odpalająca dowolny servlet i zwracająca z niego wyniki */
function ServletExecution(servlet,arg)
{
    var req = servlet;            //compiling the request
    var text = "";
    try
    {                                     //create a request for netscape, mozilla, opera, etc.
    	request = new XMLHttpRequest();
    	request.overrideMimeType('text/xml');
    }
    catch (e)
    {              
    	try
    	{                                 //create a request for internet explorer
    		request = new ActiveXObject("Microsoft.XMLHTTP");
    	}
    	catch (e)
    	{                           //do some error-handling
    		alert("XMLHttpRequest error: " + e);
    	}
    }
    request.open("POST", req, false);
    request.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset:UTF-8');
    request.send(arg);
    
    xmlDoc = request.responseXML;
    return xmlDoc;
}

function oeViewReady(grid)
{
	eoCalculateEoCost();
	var tabela = grid.getStore();
	var obsolete_from_table = tabela.sum('obsolete_value');
	var obsolete_at_sup_from_table = tabela.sum('obsolete_value_at_sup');
	var sum_obsolete_from_table = (Math.round(obsolete_from_table*100) + Math.round(obsolete_at_sup_from_table*100))/100;
	document.getElementById('obsolete_sum').value=sum_obsolete_from_table;
	
	var eo_sum = Math.round(parseFloat(document.getElementById('eo_cost').value.replace(",","."))*100);
	var localization_sum = Math.round(parseFloat(document.getElementById('localization_cost').value.replace(",","."))*100);
	var scrap_sum = Math.round(parseFloat(document.getElementById('scrap_cost').value.replace(",","."))*100);
	var rework_sum = Math.round(parseFloat(document.getElementById('rework_cost').value.replace(",","."))*100);
	var obsolete_sum = Math.round(sum_obsolete_from_table*100);
	var aditional_sum = Math.round(parseFloat(document.getElementById('additional_costs').value.replace(",","."))*100);
	
	var total_sum = eo_sum + localization_sum + scrap_sum + rework_sum + obsolete_sum + aditional_sum;
	document.getElementById('total_cost').value=total_sum/100;
	
	P0045eoKolorowanieLinii(grid);
}

function eoCalculateEoCost()
{
	//wykonanie servletu przeliczającego koszt etapów procesu EO
	var sServletName="P0045.eo.P0045CalculateProcessEoCost.customServlet";
	var arg="param="+processId;
	var zwrotka = ServletExecution(sServletName,arg);
	var item = zwrotka.getElementsByTagName('item');
	var wynik = item[0].getElementsByTagName('value')[0].firstChild.data;
	if (wynik=="ERROR")
	{
		alert("Wystąpił problem podczas otwierania zadania. Spróbuj wejść w zadanie ponownie.");
	}
	else
	{
		document.getElementById('eo_cost').value=wynik;
	}
}

function eoExportDataFromTableToXlsx(button, event)
{
	var sProcessId = document.getElementsByName('processId')[0].value;

	var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = store.getCount();
	if(iloscLinii==0)
	{
		var komunikat = "Table is empty.";
		alert(komunikat);
		return false;
	}
	
	var strData = 'Item no<col>Revision<col>Old item no<col>Belongs to<col>Item name<col>New item<col>Type of purchase<col>To be obsolete<col>Part type<col>Item desc<col>Product group<col>New amount<col>Sourcing needed<col>Logistic needed<col>SD needed<col>';
	var storeKeysUsed=new Array();
	storeKeysUsed[0]='new_item_no';
	storeKeysUsed[1]='old_item_no';
	storeKeysUsed[2]='belongs_to';
	storeKeysUsed[3]='item_name';
	storeKeysUsed[4]='new_item';
	storeKeysUsed[5]='type_of_purchase';
	storeKeysUsed[6]='obsolete';
	storeKeysUsed[7]='part_type';
	storeKeysUsed[8]='item_desc';
	storeKeysUsed[9]='product_group';
	storeKeysUsed[10]='new_amount';
	storeKeysUsed[11]='revision';
	storeKeysUsed[12]='sourcing_needed';
	storeKeysUsed[13]='logistic_needed';
	storeKeysUsed[14]='sd_needed';
	var storeKeysTypes = new Array();
	storeKeysTypes[0]='string';
	storeKeysTypes[1]='string';
	storeKeysTypes[2]='string';
	storeKeysTypes[3]='string';
	storeKeysTypes[4]='string';
	storeKeysTypes[5]='string';
	storeKeysTypes[6]='string';
	storeKeysTypes[7]='string';
	storeKeysTypes[8]='string';
	storeKeysTypes[9]='string';
	storeKeysTypes[10]='double';
	storeKeysTypes[11]='string';
	storeKeysTypes[12]='string';
	storeKeysTypes[13]='string';
	storeKeysTypes[14]='string';
	
	var storeKeys = store.fields.keys;
	
	for(var i=0; i<iloscLinii; i++)
	{
		oRecord = store.getAt(i);
		var rec = '';
		for(j=1; j<storeKeys.length; j++)	//j=1, poniewaz pierwsza kolumna jest numerator
		{
			var included = false;
			var number=0;
			for (var k=0;k<storeKeysUsed.length;k++)
			{
				if (storeKeysUsed[k]==storeKeys[j] )
				{
					included=true;
					number=k;
					break;
				} //end_if
			} //end_for
			if (included)
			{
				recValue = oRecord.get(storeKeys[j]);
				if (storeKeysTypes[k]=='double')
				{
					recValue = parseInt(Math.round(recValue*100))/100;
				}

				if (storeKeysTypes[k]=='date')
					rec += recValue+"<valueType>string";
				else
					rec += recValue+"<valueType>"+storeKeysTypes[k];
				rec +='<col>';
				
			} //end_if
		} //end_for
		strData += "<row>"+rec;
	} //end_for
	
	var servletName = "P0045.eo.P0045ExportDataToXlsx.customServlet";
	var args = "strData="+encodeURIComponent(strData);
	args+="&action=create";
	args+="&processId="+sProcessId;
	
	var zwrotka = ServletExecution(servletName, args);
	var odpowiedz = zwrotka.getElementsByTagName("value")[0].firstChild.data;
	if (odpowiedz=="ok")
	{
		args = '';
		args = "strData=";
		args += "&action=show";
		args += "&processId=" + sProcessId;
		
		curUrl = document.location.href;
		lasSymbol = curUrl.lastIndexOf('/');
		curUrl = curUrl.substring(0, lasSymbol);
		curUrl += '/P0045.eo.P0045ExportDataToXlsx.customServlet?'+args;
		window.open(curUrl,"mywindow");
	}
	else
	{
		var komunikat = "An error has occured during data export.";
		alert(komunikat);
	}
}

function eoShowJExcelImportPanel()
{
	var colsId = new Array();
	colsId[0]='new_item_no';
	colsId[1]='old_item_no';
	colsId[2]='belongs_to';
	colsId[3]='item_name';
	colsId[4]='new_item';
	colsId[5]='type_of_purchase';
	colsId[6]='obsolete';
	colsId[7]='part_type';
	colsId[8]='item_desc';
	colsId[9]='product_group';
	colsId[10]='new_amount';
	colsId[11]='revision';
	colsId[12]='sourcing_needed';
	colsId[13]='logistic_needed';
	colsId[14]='sd_needed';
	
	var colsMapping = new Array();
	colsMapping[0]='Item no';
	colsMapping[1]='Old item no';
	colsMapping[2]='Belongs to';
	colsMapping[3]='Item name';
	colsMapping[4]='New item';
	colsMapping[5]='Type of purchase';
	colsMapping[6]='To be obsolete';
	colsMapping[7]='Part type';
	colsMapping[8]='Item desc';
	colsMapping[9]='Product group';
	colsMapping[10]='New amount';
	colsMapping[11]='Revision';
	colsMapping[12]='Sourcing needed';
	colsMapping[13]='Logistic needed';
	colsMapping[14]='SD needed';

	var fs;
	fs = new Ext.FormPanel({
		fileUpload: true, //(1)
		width: '100%',
		frame: true,
		//title: 'File Upload',
		bodyStyle: 'padding: 10px 10px 0 10px;',
		labelWidth: 100,
		items: 
		[
		    {
				xtype: 'fileuploadfield',
				emptyText: 'Choose xlsx file...',
				fieldLabel: 'Plik xlsx',
				name: 'file', //(2)
				buttonText: 'Choose file...',
				width: '100%',
				autowidth: true,
				id:'Xls_panel_label'
			},
		    {
		        xtype      : 'checkbox',
		        fieldLabel : "Keep current values",
		        boxLabel   : '',
		        inputValue : '',
		        id	   	   : 'Xls_panel_checkbox',
		        checked	   : false
		      }
		      
		],
			buttons: [
            {
				text: 'Enter',
				handler: function()
				{
					var v = Ext.get('Xls_panel_label').getValue();
						
					var checkboxVal = Ext.getCmp('Xls_panel_checkbox').getValue();

					if(v=='Choose xlsx file...' || v=='')
					{
							Ext.Msg.show({
								title: 'Info',
								msg: 'Choose file first.',
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.INFO
							});
					}
					else
					{
						fs.getForm().submit(
						{
							url: 'com.plusmpm.servlet.extension.P0045.eo.P0045LoadDataFromXlsx.customServlet?cols=' + colsMapping.join(";")+"&colIds="+colsId.join(";"),
							waitMsg: 'File Processing...',
							waitTitle : 'Please wait',

							success: function(form, action) //(3)
							{
								P0045eoSetDataInTable( action.result.data, !checkboxVal);
								win.close();
							},
							failure: function(form, action) //(4)action.result
							{
								Ext.Msg.alert('Error', 'An error has occured during file processing. Check file extension and columns names in xlsx file.');
							}
						});
					}
				}
			}]
		});
		
	win = new Ext.Window({
				layout: 'fit',
				height: 160,
				width: 530,
				//autoheight: true,
				//autowidth: true,
				shadow: false,
				closable: true,
				constrain: true,
				title: 'Xlsx Load',
				draggable: true,
				plain: true,
				resizable: false,
				modal: true,
				items: fs
            });
        
        win.show(this);
}

function P0045eoSetDataInTable(data, removeOldRecords)
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	tabela.autoSave=false;

	if(removeOldRecords)
	{
		clientSynchroRemoveAllRecordsFromStore(tabela);
		tabela.removeAll(true);
	}
	
	var jsonData = Ext.util.JSON.decode(data);
	var jr = jsonData.records;
	var wielkoscTablicy=jr.length;
	try
	{
		tabela.autoSave = false;
		for (var i=0;i<wielkoscTablicy;i++)
		{
			var nowyWiersz = new tabela.recordType;
			var kol0 = jr[i].new_item_no;
			var kol1 = jr[i].old_item_no;
			var kol2 = jr[i].item_name;
			var kol3 = jr[i].new_item;
			var kol4 = jr[i].type_of_purchase;
			var kol5 = jr[i].obsolete;
			var kol6 = jr[i].part_type;
			var kol7 = jr[i].item_desc;
			var kol8 = jr[i].product_group;
			var kol9 = jr[i].new_amount;
			var kol10 = jr[i].revision;
			var kol11 = jr[i].sourcing_needed;
			var kol12 = jr[i].belongs_to;
			var kol13 = jr[i].logistic_needed;
			var kol14 = jr[i].sd_needed;
			nowyWiersz.set('new_item_no',kol0);
			nowyWiersz.set('old_item_no',kol1);
			nowyWiersz.set('item_name',kol2);
			nowyWiersz.set('new_item',kol3);
			nowyWiersz.set('type_of_purchase',kol4);
			nowyWiersz.set('obsolete',kol5);
			nowyWiersz.set('part_type',kol6);
			nowyWiersz.set('item_desc',kol7);
			nowyWiersz.set('product_group',kol8);
			nowyWiersz.set('new_amount',kol9);
			nowyWiersz.set('revision',kol10);
			nowyWiersz.set('sourcing_needed',kol11);
			nowyWiersz.set('belongs_to',kol12);
			nowyWiersz.set('logistic_needed',kol13);
			nowyWiersz.set('sd_needed',kol14);
			tabela.add(nowyWiersz);
		}
		tabela.save();
	}
	catch(oError)
	{
		tabela.rejectChanges();
		var komunikat = "An error has occured during adding data from Excel file to table. Check data in file.";
		alert(komunikat);
	}
	finally
	{
		tabela.autoSave = true;
	}
}

function clientSynchroRemoveAllRecordsFromStore(store)
{
	//Synchroniczne wywolanie servletu usuwajace rekordy z Tabeli tymczasowej pm_variable_set_temp
	var recToDel;
	for(var i=0; i<store.getCount(); i++)
	{
		if(i==0) recToDel='[';
		else recToDel+=',';
		
		recToDel += '"' + i + '"';
		
		if(i==store.getCount()-1) recToDel+=']';
	}
	
	if (recToDel!=null)
	{
		var sServletName = 'com.plusmpm.servlet.VariableSetOperationsServlet.customServlet';
		var arg = "activityId="+activityId+"&processId="+processId+"&records="+recToDel;
		
		var keys = store.fields.keys;
		for(var i=0; i<keys.length; i++)
		{
			if(keys[i]!='row_number_column_id')
				arg += "&workflowVariables="+keys[i];
		}	
		
		arg += "&xaction=destroy";
		ServletExecution(sServletName,arg);
	}
}

function eoExportDataFromTableToXlsxSourcing(button, event)
{
	var sProcessId = document.getElementsByName('processId')[0].value;

	var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = store.getCount();
	if(iloscLinii==0)
	{
		var komunikat = "Table is empty.";
		alert(komunikat);
		return false;
	}
	
	var strData = 'Item no<col>Revision<col>Old item no<col>Belongs to<col>Item name<col>New item<col>Type of purchase<col>To be obsolete<col>Part type<col>Item desc<col>Product group<col>New amount<col>New price<col>Change availibility<col>Availibility date<col>Lead Time<col>Vendor no<col>Vendor name<col>Obsolete value at Sup.<col>Responsible - Sourcing<col>Item status - Sourcing<col>';
	var storeKeysUsed=new Array();
	storeKeysUsed[0]='new_item_no';
	storeKeysUsed[1]='old_item_no';
	storeKeysUsed[2]='belongs_to';
	storeKeysUsed[3]='item_name';
	storeKeysUsed[4]='new_item';
	storeKeysUsed[5]='type_of_purchase';
	storeKeysUsed[6]='obsolete';
	storeKeysUsed[7]='part_type';
	storeKeysUsed[8]='item_desc';
	storeKeysUsed[9]='product_group';
	storeKeysUsed[10]='new_amount';
	storeKeysUsed[11]='revision';
	storeKeysUsed[12]='new_price';
	storeKeysUsed[13]='change_availibility';
	storeKeysUsed[14]='availibility_date';
	storeKeysUsed[15]='lead_time';
	storeKeysUsed[16]='vendor_no';
	storeKeysUsed[17]='vendor_name';
	storeKeysUsed[18]='obsolete_value_at_sup';
	storeKeysUsed[19]='responsible_sourcing';
	storeKeysUsed[20]='item_status_sourcing';
	var storeKeysTypes = new Array();
	storeKeysTypes[0]='string';
	storeKeysTypes[1]='string';
	storeKeysTypes[2]='string';
	storeKeysTypes[3]='string';
	storeKeysTypes[4]='string';
	storeKeysTypes[5]='string';
	storeKeysTypes[6]='string';
	storeKeysTypes[7]='string';
	storeKeysTypes[8]='string';
	storeKeysTypes[9]='string';
	storeKeysTypes[10]='double';
	storeKeysTypes[11]='string';
	storeKeysTypes[12]='string';
	storeKeysTypes[13]='string';
	storeKeysTypes[14]='date';
	storeKeysTypes[15]='string';
	storeKeysTypes[16]='string';
	storeKeysTypes[17]='string';
	storeKeysTypes[18]='double';
	storeKeysTypes[19]='string';
	storeKeysTypes[20]='string';
	
	var storeKeys = store.fields.keys;
	
	for(var i=0; i<iloscLinii; i++)
	{
		oRecord = store.getAt(i);
		var rec = '';
		for(j=1; j<storeKeys.length; j++)	//j=1, poniewaz pierwsza kolumna jest numerator
		{
			var included = false;
			var number=0;
			for (var k=0;k<storeKeysUsed.length;k++)
			{
				if (storeKeysUsed[k]==storeKeys[j] )
				{
					included=true;
					number=k;
					break;
				} //end_if
			} //end_for
			if (included)
			{
				recValue = oRecord.get(storeKeys[j]);
				if (recValue==null)
					recValue="";
				if (storeKeysTypes[k]=='double')
				{
					if (recValue!=null && recValue!='')
						recValue = parseInt(Math.round(recValue*100))/100;
				}
				else if (storeKeysTypes[k]=='date')
				{
					if (recValue!=null && recValue!='')
						recValue = recValue.format("Y-m-d");
					storeKeysTypes[k]='string';
				}

				if (storeKeysTypes[k]=='date')
					rec += recValue+"<valueType>string";
				else
					rec += recValue+"<valueType>"+storeKeysTypes[k];
				rec +='<col>';
				
			} //end_if
		} //end_for
		strData += "<row>"+rec;
	} //end_for
	
	var servletName = "P0045.eo.P0045ExportDataToXlsx.customServlet";
	var args = "strData="+encodeURIComponent(strData);
	args+="&action=create";
	args+="&processId="+sProcessId;
	
	var zwrotka = ServletExecution(servletName, args);
	var odpowiedz = zwrotka.getElementsByTagName("value")[0].firstChild.data;
	if (odpowiedz=="ok")
	{
		args = '';
		args = "strData=";
		args += "&action=show";
		args += "&processId=" + sProcessId;
		
		curUrl = document.location.href;
		lasSymbol = curUrl.lastIndexOf('/');
		curUrl = curUrl.substring(0, lasSymbol);
		curUrl += '/P0045.eo.P0045ExportDataToXlsx.customServlet?'+args;
		window.open(curUrl,"mywindow");
	}
	else
	{
		var komunikat = "An error has occured during data export.";
		alert(komunikat);
	}
}

function eoExportDataFromTableToXlsxDelegateSourcing(button, event)
{
	var sProcessId = document.getElementsByName('processId')[0].value;

	var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = store.getCount();
	if(iloscLinii==0)
	{
		var komunikat = "Table is empty.";
		alert(komunikat);
		return false;
	}
	
	var strData = 'Item no<col>Revision<col>Old item no<col>Belongs to<col>Item name<col>New item<col>Type of purchase<col>To be obsolete<col>Part type<col>Item desc<col>Product group<col>New amount<col>Vendor no<col>Vendor name<col>Responsible - Sourcing<col>Sourcing needed<col>';
	var storeKeysUsed=new Array();
	storeKeysUsed[0]='new_item_no';
	storeKeysUsed[1]='revision';
	storeKeysUsed[2]='old_item_no';
	storeKeysUsed[3]='belongs_to';
	storeKeysUsed[4]='item_name';
	storeKeysUsed[5]='new_item';
	storeKeysUsed[6]='type_of_purchase';
	storeKeysUsed[7]='obsolete';
	storeKeysUsed[8]='part_type';
	storeKeysUsed[9]='item_desc';
	storeKeysUsed[10]='product_group';
	storeKeysUsed[11]='new_amount';
	storeKeysUsed[12]='vendor_no';
	storeKeysUsed[13]='vendor_name';
	storeKeysUsed[14]='responsible_sourcing';
	storeKeysUsed[15]='sourcing_needed';

	var storeKeysTypes = new Array();
	storeKeysTypes[0]='string';
	storeKeysTypes[1]='string';
	storeKeysTypes[2]='string';
	storeKeysTypes[3]='string';
	storeKeysTypes[4]='string';
	storeKeysTypes[5]='string';
	storeKeysTypes[6]='string';
	storeKeysTypes[7]='string';
	storeKeysTypes[8]='string';
	storeKeysTypes[9]='string';
	storeKeysTypes[10]='string';
	storeKeysTypes[11]='double';
	storeKeysTypes[12]='string';
	storeKeysTypes[13]='string';
	storeKeysTypes[14]='string';
	storeKeysTypes[15]='string';
	
	var storeKeys = store.fields.keys;
	
	for(var i=0; i<iloscLinii; i++)
	{
		oRecord = store.getAt(i);
		var rec = '';
		for(j=1; j<storeKeys.length; j++)	//j=1, poniewaz pierwsza kolumna jest numerator
		{
			var included = false;
			var number=0;
			for (var k=0;k<storeKeysUsed.length;k++)
			{
				if (storeKeysUsed[k]==storeKeys[j] )
				{
					included=true;
					number=k;
					break;
				} //end_if
			} //end_for
			if (included)
			{
				recValue = oRecord.get(storeKeys[j]);
				if (recValue==null)
					recValue="";
				if (storeKeysTypes[k]=='double')
				{
					if (recValue!=null && recValue!='')
						recValue = parseInt(Math.round(recValue*100))/100;
				}
				else if (storeKeysTypes[k]=='date')
				{
					if (recValue!=null && recValue!='')
						recValue = recValue.format("Y-m-d");
					storeKeysTypes[k]='string';
				}

				if (storeKeysTypes[k]=='date')
					rec += recValue+"<valueType>string";
				else
					rec += recValue+"<valueType>"+storeKeysTypes[k];
				rec +='<col>';
				
			} //end_if
		} //end_for
		strData += "<row>"+rec;
	} //end_for
	
	var servletName = "P0045.eo.P0045ExportDataToXlsx.customServlet";
	var args = "strData="+encodeURIComponent(strData);
	args+="&action=create";
	args+="&processId="+sProcessId;
	
	var zwrotka = ServletExecution(servletName, args);
	var odpowiedz = zwrotka.getElementsByTagName("value")[0].firstChild.data;
	if (odpowiedz=="ok")
	{
		args = '';
		args = "strData=";
		args += "&action=show";
		args += "&processId=" + sProcessId;
		
		curUrl = document.location.href;
		lasSymbol = curUrl.lastIndexOf('/');
		curUrl = curUrl.substring(0, lasSymbol);
		curUrl += '/P0045.eo.P0045ExportDataToXlsx.customServlet?'+args;
		window.open(curUrl,"mywindow");
	}
	else
	{
		var komunikat = "An error has occured during data export.";
		alert(komunikat);
	}
}

function eoExportDataFromTableToXlsxLogistic(button, event)
{
	var sProcessId = document.getElementsByName('processId')[0].value;

	var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = store.getCount();
	if(iloscLinii==0)
	{
		var komunikat = "Table is empty.";
		alert(komunikat);
		return false;
	}
	
	var strData = 'Item no<col>Revision<col>Old item no<col>Belongs to<col>Item name<col>New item<col>Type of purchase<col>To be obsolete<col>Part type<col>Item desc<col>Product group<col>New amount<col>New price<col>Change availibility<col>Availibility date<col>Lead Time<col>Vendor no<col>Vendor name<col>Responsible - Sourcing<col>Responsible - Logistic<col>Stock in MAU<col>Stock value in MAU<col>Stock at sup.<col>Stock value at sup.<col>Obsolete value<col>Stock end date<col>Row comment<col>Influence on project<col>Influence desc<col>Proposal<col>';
	var storeKeysUsed=new Array();
	storeKeysUsed[0]='new_item_no';
	storeKeysUsed[1]='old_item_no';
	storeKeysUsed[2]='belongs_to';
	storeKeysUsed[3]='item_name';
	storeKeysUsed[4]='new_item';
	storeKeysUsed[5]='type_of_purchase';
	storeKeysUsed[6]='obsolete';
	storeKeysUsed[7]='part_type';
	storeKeysUsed[8]='item_desc';
	storeKeysUsed[9]='product_group';
	storeKeysUsed[10]='new_amount';
	storeKeysUsed[11]='revision';
	storeKeysUsed[12]='new_price';
	storeKeysUsed[13]='change_availibility';
	storeKeysUsed[14]='availibility_date';
	storeKeysUsed[15]='lead_time';
	storeKeysUsed[16]='vendor_no';
	storeKeysUsed[17]='vendor_name';
	storeKeysUsed[18]='responsible_sourcing';
	storeKeysUsed[19]='responsible_logistics';
	storeKeysUsed[20]='stock_in_mau';
	storeKeysUsed[21]='stock_value_in_mau';
	storeKeysUsed[22]='stock_at_supplier';
	storeKeysUsed[23]='stock_value_at_supplier';
	storeKeysUsed[24]='obsolete_value';
	storeKeysUsed[25]='stock_end_date';
	storeKeysUsed[26]='row_comment';
	storeKeysUsed[27]='influence_on_project';
	storeKeysUsed[28]='influence_desc';
	storeKeysUsed[29]='proposal';
	var storeKeysTypes = new Array();
	storeKeysTypes[0]='string';
	storeKeysTypes[1]='string';
	storeKeysTypes[2]='string';
	storeKeysTypes[3]='string';
	storeKeysTypes[4]='string';
	storeKeysTypes[5]='string';
	storeKeysTypes[6]='string';
	storeKeysTypes[7]='string';
	storeKeysTypes[8]='string';
	storeKeysTypes[9]='string';
	storeKeysTypes[10]='double';
	storeKeysTypes[11]='string';
	storeKeysTypes[12]='string';
	storeKeysTypes[13]='string';
	storeKeysTypes[14]='date';
	storeKeysTypes[15]='string';
	storeKeysTypes[16]='string';
	storeKeysTypes[17]='string';
	storeKeysTypes[18]='string';
	storeKeysTypes[19]='string';
	storeKeysTypes[20]='double';
	storeKeysTypes[21]='double';
	storeKeysTypes[22]='double';
	storeKeysTypes[23]='double';
	storeKeysTypes[24]='double';
	storeKeysTypes[25]='date';
	storeKeysTypes[26]='string';
	storeKeysTypes[27]='string';
	storeKeysTypes[28]='string';
	storeKeysTypes[29]='string';
	
	var storeKeys = store.fields.keys;
	
	for(var i=0; i<iloscLinii; i++)
	{
		oRecord = store.getAt(i);
		var rec = '';
		for(j=1; j<storeKeys.length; j++)	//j=1, poniewaz pierwsza kolumna jest numerator
		{
			var included = false;
			var number=0;
			for (var k=0;k<storeKeysUsed.length;k++)
			{
				if (storeKeysUsed[k]==storeKeys[j] )
				{
					included=true;
					number=k;
					break;
				} //end_if
			} //end_for
			if (included)
			{
				recValue = oRecord.get(storeKeys[j]);
				if (recValue==null)
					recValue="";
				if (storeKeysTypes[k]=='double')
				{
					if (recValue!=null && recValue!='')
						recValue = parseInt(Math.round(recValue*100))/100;
				}
				else if (storeKeysTypes[k]=='date')
				{
					if (recValue!=null && recValue!='')
						recValue = recValue.format("Y-m-d");
				}

				if (storeKeysTypes[k]=='date')
					rec += recValue+"<valueType>string";
				else
					rec += recValue+"<valueType>"+storeKeysTypes[k];
				rec +='<col>';
				
			} //end_if
		} //end_for
		strData += "<row>"+rec;
	} //end_for
	
	var servletName = "P0045.eo.P0045ExportDataToXlsx.customServlet";
	var args = "strData="+encodeURIComponent(strData);
	args+="&action=create";
	args+="&processId="+sProcessId;
	
	var zwrotka = ServletExecution(servletName, args);
	var odpowiedz = zwrotka.getElementsByTagName("value")[0].firstChild.data;
	if (odpowiedz=="ok")
	{
		args = '';
		args = "strData=";
		args += "&action=show";
		args += "&processId=" + sProcessId;
		
		curUrl = document.location.href;
		lasSymbol = curUrl.lastIndexOf('/');
		curUrl = curUrl.substring(0, lasSymbol);
		curUrl += '/P0045.eo.P0045ExportDataToXlsx.customServlet?'+args;
		window.open(curUrl,"mywindow");
	}
	else
	{
		var komunikat = "An error has occured during data export.";
		alert(komunikat);
	}
}

function eoExportDataFromTableToXlsxDelegateLogistic(button, event)
{
	var sProcessId = document.getElementsByName('processId')[0].value;

	var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	var iloscLinii = store.getCount();
	if(iloscLinii==0)
	{
		var komunikat = "Table is empty.";
		alert(komunikat);
		return false;
	}
	
	var strData = 'Item no<col>Revision<col>Old item no<col>Belongs to<col>Item name<col>New item<col>Type of purchase<col>To be obsolete<col>Part type<col>Item desc<col>Product group<col>New amount<col>New price<col>Change availibility<col>Availibility date<col>Lead Time<col>Vendor no<col>Vendor name<col>Responsible - Sourcing<col>Responsible - Logistic<col>Comment<col>Influence on project<col>Influence desc<col>Logistic needed<col>';
	var storeKeysUsed=new Array();
	storeKeysUsed[0]='new_item_no';
	storeKeysUsed[1]='old_item_no';
	storeKeysUsed[2]='belongs_to';
	storeKeysUsed[3]='item_name';
	storeKeysUsed[4]='new_item';
	storeKeysUsed[5]='type_of_purchase';
	storeKeysUsed[6]='obsolete';
	storeKeysUsed[7]='part_type';
	storeKeysUsed[8]='item_desc';
	storeKeysUsed[9]='product_group';
	storeKeysUsed[10]='new_amount';
	storeKeysUsed[11]='revision';
	storeKeysUsed[12]='new_price';
	storeKeysUsed[13]='change_availibility';
	storeKeysUsed[14]='availibility_date';
	storeKeysUsed[15]='lead_time';
	storeKeysUsed[16]='vendor_no';
	storeKeysUsed[17]='vendor_name';
	storeKeysUsed[18]='responsible_sourcing';
	storeKeysUsed[19]='responsible_logistics';
	storeKeysUsed[20]='row_comment';
	storeKeysUsed[21]='influence_on_project';
	storeKeysUsed[22]='influence_desc';
	storeKeysUsed[23]='logistic_needed';

	var storeKeysTypes = new Array();
	storeKeysTypes[0]='string';
	storeKeysTypes[1]='string';
	storeKeysTypes[2]='string';
	storeKeysTypes[3]='string';
	storeKeysTypes[4]='string';
	storeKeysTypes[5]='string';
	storeKeysTypes[6]='string';
	storeKeysTypes[7]='string';
	storeKeysTypes[8]='string';
	storeKeysTypes[9]='string';
	storeKeysTypes[10]='double';
	storeKeysTypes[11]='string';
	storeKeysTypes[12]='string';
	storeKeysTypes[13]='string';
	storeKeysTypes[14]='date';
	storeKeysTypes[15]='string';
	storeKeysTypes[16]='string';
	storeKeysTypes[17]='string';
	storeKeysTypes[18]='string';
	storeKeysTypes[19]='string';
	storeKeysTypes[20]='string';
	storeKeysTypes[21]='string';
	storeKeysTypes[22]='string';
	storeKeysTypes[23]='string';
	
	var storeKeys = store.fields.keys;
	
	for(var i=0; i<iloscLinii; i++)
	{
		oRecord = store.getAt(i);
		var rec = '';
		for(j=1; j<storeKeys.length; j++)	//j=1, poniewaz pierwsza kolumna jest numerator
		{
			var included = false;
			var number=0;
			for (var k=0;k<storeKeysUsed.length;k++)
			{
				if (storeKeysUsed[k]==storeKeys[j] )
				{
					included=true;
					number=k;
					break;
				} //end_if
			} //end_for
			if (included)
			{
				recValue = oRecord.get(storeKeys[j]);
				if (recValue==null)
					recValue="";
				if (storeKeysTypes[k]=='double')
				{
					if (recValue!=null && recValue!='')
						recValue = parseInt(Math.round(recValue*100))/100;
				}
				else if (storeKeysTypes[k]=='date')
				{
					if (recValue!=null && recValue!='')
						recValue = recValue.format("Y-m-d");
				}

				if (storeKeysTypes[k]=='date')
					rec += recValue+"<valueType>string";
				else
					rec += recValue+"<valueType>"+storeKeysTypes[k];
				rec +='<col>';
				
			} //end_if
		} //end_for
		strData += "<row>"+rec;
	} //end_for
	
	var servletName = "P0045.eo.P0045ExportDataToXlsx.customServlet";
	var args = "strData="+encodeURIComponent(strData);
	args+="&action=create";
	args+="&processId="+sProcessId;
	
	var zwrotka = ServletExecution(servletName, args);
	var odpowiedz = zwrotka.getElementsByTagName("value")[0].firstChild.data;
	if (odpowiedz=="ok")
	{
		args = '';
		args = "strData=";
		args += "&action=show";
		args += "&processId=" + sProcessId;
		
		curUrl = document.location.href;
		lasSymbol = curUrl.lastIndexOf('/');
		curUrl = curUrl.substring(0, lasSymbol);
		curUrl += '/P0045.eo.P0045ExportDataToXlsx.customServlet?'+args;
		window.open(curUrl,"mywindow");
	}
	else
	{
		var komunikat = "An error has occured during data export.";
		alert(komunikat);
	}
}

function eoShowJExcelImportPanelSourcing()
{
	var colsId = new Array();
	colsId[0]='new_item_no';
	colsId[1]='old_item_no';
	colsId[2]='belongs_to';
	colsId[3]='item_name';
	colsId[4]='new_item';
	colsId[5]='type_of_purchase';
	colsId[6]='obsolete';
	colsId[7]='part_type';
	colsId[8]='item_desc';
	colsId[9]='product_group';
	colsId[10]='new_amount';
	colsId[11]='revision';
	colsId[12]='new_price';
	colsId[13]='change_availibility';
	colsId[14]='availibility_date';
	colsId[15]='lead_time';
	colsId[16]='vendor_no';
	colsId[17]='vendor_name';
	colsId[18]='obsolete_value_at_sup';
	colsId[19]='responsible_sourcing';
	colsId[20]='item_status_sourcing';
	
	var colsMapping = new Array();
	colsMapping[0]='Item no';
	colsMapping[1]='Old item no';
	colsMapping[2]='Belongs to';
	colsMapping[3]='Item name';
	colsMapping[4]='New item';
	colsMapping[5]='Type of purchase';
	colsMapping[6]='To be obsolete';
	colsMapping[7]='Part type';
	colsMapping[8]='Item desc';
	colsMapping[9]='Product group';
	colsMapping[10]='New amount';
	colsMapping[11]='Revision';
	colsMapping[12]='New price';
	colsMapping[13]='Change availibility';
	colsMapping[14]='Availibility date';
	colsMapping[15]='Lead Time';
	colsMapping[16]='Vendor no';
	colsMapping[17]='Vendor name';
	colsMapping[18]='Obsolete value at Sup.';
	colsMapping[19]='Responsible - Sourcing';
	colsMapping[20]='Item status - Sourcing';
	
	var fs;
	fs = new Ext.FormPanel({
		fileUpload: true, //(1)
		width: '100%',
		frame: true,
		//title: 'File Upload',
		bodyStyle: 'padding: 10px 10px 0 10px;',
		labelWidth: 100,
		items: 
			[
			    {
					xtype: 'fileuploadfield',
					emptyText: 'Choose xlsx file...',
					fieldLabel: 'Plik xlsx',
					name: 'file', //(2)
					buttonText: 'Choose file...',
					width: '100%',
					autowidth: true,
					id:'Xls_panel_label'
				},
			    {
			        xtype      : 'checkbox',
			        fieldLabel : "Keep current values",
			        boxLabel   : '',
			        inputValue : '',
			        id	   	   : 'Xls_panel_checkbox',
			        checked	   : false
			      }
			      
			],
			buttons: [
            {
				text: 'Enter',
				handler: function()
				{
					var v = Ext.get('Xls_panel_label').getValue();
					var checkboxVal = Ext.getCmp('Xls_panel_checkbox').getValue();

					if(v=='Choose xlsx file...' || v=='')
					{
							Ext.Msg.show({
								title: 'Info',
								msg: 'Choose file first.',
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.INFO
							});
					}
					else
					{
						fs.getForm().submit(
						{
							url: 'com.plusmpm.servlet.extension.P0045.eo.P0045LoadDataFromXlsx.customServlet?cols=' + colsMapping.join(";")+"&colIds="+colsId.join(";"),
							waitMsg: 'File Processing...',
							waitTitle : 'Please wait',

							success: function(form, action) //(3)
							{
								P0045eoSetDataInTableSourcing( action.result.data, !checkboxVal);
								win.close();
							},
							failure: function(form, action) //(4)action.result
							{
								Ext.Msg.alert('Error', 'An error has occured during file processing. Check file extension and columns names in xlsx file.');
							}
						});
					}
				}
			}]
		});
		
	win = new Ext.Window({
				layout: 'fit',
				height: 160,
				width: 530,
				//autoheight: true,
				//autowidth: true,
				shadow: false,
				closable: true,
				constrain: true,
				title: 'Xlsx Load',
				draggable: true,
				plain: true,
				resizable: false,
				modal: true,
				items: fs
            });
        
    win.show(this);

}

function P0045eoSetDataInTableSourcing(data, replaceCurrentValues)
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	tabela.autoSave=false;
	
	var jsonData = Ext.util.JSON.decode(data);
	var jr = jsonData.records;
	var wielkoscTablicy=jr.length;
	var wielkoscTabeli = tabela.getCount();
	
	if (wielkoscTablicy!=wielkoscTabeli)
	{
		alert("Number of rows in excel file ("+wielkoscTablicy+") doesn't match number of rows in table ("+wielkoscTabeli+"). File cannot be imported.");
		return;
	}
	
	try
	{
		tabela.autoSave = false;
		for (var i=0;i<wielkoscTablicy;i++)
		{
			var wiersz = tabela.getAt(i);
			var kol0 = jr[i].new_item_no;
			var kol1 = jr[i].old_item_no;
			var kol2 = jr[i].item_name;
			var kol3 = jr[i].new_item;
			var kol4 = jr[i].type_of_purchase;
			var kol5 = jr[i].obsolete;
			var kol6 = jr[i].part_type;
			var kol7 = jr[i].item_desc;
			var kol8 = jr[i].product_group;
			var kol9 = jr[i].new_amount;
			var kol10 = jr[i].revision;
			var kol11 = jr[i].new_price;
			var kol12 = jr[i].change_availibility;
			var kol13 = jr[i].availibility_date;
			var kol14 = jr[i].vendor_no;
			var kol15 = jr[i].vendor_name;
			var kol16 = jr[i].responsible_sourcing;
			var kol20 = jr[i].responsible_sourcing_login;
			var kol17 = jr[i].item_status_sourcing;
			var kol18 = jr[i].obsolete_value_at_sup;
			var kol19 = jr[i].lead_time;
			if (replaceCurrentValues)
			{
				wiersz.set('new_price',kol11);
				wiersz.set('change_availibility',kol12);
				if (kol13!="")
					wiersz.set('availibility_date',P0045ExcelDateToJSDate(kol13));
				if (kol19!="")
					wiersz.set('lead_time',P0045ExcelDateToJSDate(kol19));
				wiersz.set('vendor_no',kol14);
				wiersz.set('vendor_name',kol15);
				wiersz.set('obsolete_value_at_sup',kol18);
				wiersz.set('item_status_sourcing',kol17);
			}
			else
			{
				temp = wiersz.get('new_price');
				if (temp=='')
				{
					wiersz.set('new_price',kol11);
				}
				temp = wiersz.get('change_availibility');
				if (temp=='')
				{
					wiersz.set('change_availibility',kol12);
				}
				temp = wiersz.get('availibility_date');
				if (temp=='')
				{
					if (kol13!="")
						wiersz.set('availibility_date',P0045ExcelDateToJSDate(kol13));
				}
				temp = wiersz.get('lead_time');
				if (temp=='')
				{
					if (kol19!="")
					{
						//wiersz.set('lead_time',P0045ExcelDateToJSDate(kol19));
						wiersz.set('lead_time',kol19);
					}
				}
				temp = wiersz.get('vendor_no');
				if (temp=='')
				{
					wiersz.set('vendor_no',kol14);
				}
				temp = wiersz.get('vendor_name');
				if (temp=='')
				{
					wiersz.set('vendor_name',kol15);
				}
				temp = wiersz.get('obsolete_value_at_sup');
				if (temp=='')
				{
					wiersz.set('obsolete_value_at_sup',kol18);
				}
				temp = wiersz.get('item_status_sourcing');
				if (temp=='')
				{
					wiersz.set('item_status_sourcing',kol17);
				}
			}
		}
		tabela.save();
	}
	catch(oError)
	{
		tabela.rejectChanges();
		var komunikat = "An error has occured during adding data from Excel file to table. Check data in file.";
		alert(komunikat);
	}
	finally
	{
		tabela.autoSave = true;
	}
}

function eoShowJExcelImportPanelDelegateSourcing()
{
	var colsId = new Array();
	colsId[0]='new_item_no';
	colsId[1]='old_item_no';
	colsId[2]='belongs_to';
	colsId[3]='item_name';
	colsId[4]='new_item';
	colsId[5]='type_of_purchase';
	colsId[6]='obsolete';
	colsId[7]='part_type';
	colsId[8]='item_desc';
	colsId[9]='product_group';
	colsId[10]='new_amount';
	colsId[11]='vendor_no';
	colsId[12]='vendor_name';
	colsId[13]='responsible_sourcing';
	
	var colsMapping = new Array();
	colsMapping[0]='Item no';
	colsMapping[1]='Old item no';
	colsMapping[2]='Belongs to';
	colsMapping[3]='Item name';
	colsMapping[4]='New item';
	colsMapping[5]='Type of purchase';
	colsMapping[6]='To be obsolete';
	colsMapping[7]='Part type';
	colsMapping[8]='Item desc';
	colsMapping[9]='Product group';
	colsMapping[10]='New amount';
	colsMapping[11]='Vendor no';
	colsMapping[12]='Vendor name';
	colsMapping[13]='Responsible - Sourcing';
	
	var fs;
	fs = new Ext.FormPanel({
		fileUpload: true, //(1)
		width: '100%',
		frame: true,
		//title: 'File Upload',
		bodyStyle: 'padding: 10px 10px 0 10px;',
		labelWidth: 100,
		items: 
			[
			    {
					xtype: 'fileuploadfield',
					emptyText: 'Choose xlsx file...',
					fieldLabel: 'Plik xlsx',
					name: 'file', //(2)
					buttonText: 'Choose file...',
					width: '100%',
					autowidth: true,
					id:'Xls_panel_label'
				},
			    {
			        xtype      : 'checkbox',
			        fieldLabel : "Keep current values",
			        boxLabel   : '',
			        inputValue : '',
			        id	   	   : 'Xls_panel_checkbox',
			        checked	   : false
			      }
			      
			],
			buttons: [
            {
				text: 'Enter',
				handler: function()
				{
					var v = Ext.get('Xls_panel_label').getValue();
					var checkboxVal = Ext.getCmp('Xls_panel_checkbox').getValue();

					if(v=='Choose xlsx file...' || v=='')
					{
							Ext.Msg.show({
								title: 'Info',
								msg: 'Choose file first.',
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.INFO
							});
					}
					else
					{
						fs.getForm().submit(
						{
							url: 'com.plusmpm.servlet.extension.P0045.eo.P0045LoadDataFromXlsx.customServlet?cols=' + colsMapping.join(";")+"&colIds="+colsId.join(";"),
							waitMsg: 'File Processing...',
							waitTitle : 'Please wait',

							success: function(form, action) //(3)
							{
								P0045eoSetDataInTableDelegateSourcing( action.result.data, !checkboxVal);
								win.close();
							},
							failure: function(form, action) //(4)action.result
							{
								Ext.Msg.alert('Error', 'An error has occured during file processing. Check file extension and columns names in xlsx file.');
							}
						});
					}
				}
			}]
		});
		
	win = new Ext.Window({
				layout: 'fit',
				height: 160,
				width: 530,
				//autoheight: true,
				//autowidth: true,
				shadow: false,
				closable: true,
				constrain: true,
				title: 'Xlsx Load',
				draggable: true,
				plain: true,
				resizable: false,
				modal: true,
				items: fs
            });
        
    win.show(this);

}

function P0045eoSetDataInTableDelegateSourcing(data,replaceCurrentValues)
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	tabela.autoSave=false;
	
	var jsonData = Ext.util.JSON.decode(data);
	var jr = jsonData.records;
	var wielkoscTablicy=jr.length;
	var wielkoscTabeli = tabela.getCount();
	
	if (wielkoscTablicy!=wielkoscTabeli)
	{
		alert("Number of rows in excel file ("+wielkoscTablicy+") doesn't match number of rows in table ("+wielkoscTabeli+"). File cannot be imported.");
		return;
	}
	
	try
	{
		tabela.autoSave = false;
		for (var i=0;i<wielkoscTablicy;i++)
		{
			var wiersz = tabela.getAt(i);
			var sourcing_needed = wiersz.get('sourcing_needed');
			if (sourcing_needed=='' || sourcing_needed=='No')
			{
				continue;
			}
			var kol1 = jr[i].vendor_no;
			var kol2 = jr[i].vendor_name;
			var kol3 = jr[i].responsible_sourcing;
			var kol4 = jr[i].responsible_sourcing_login;

			if (replaceCurrentValues)
			{
				wiersz.set('vendor_no',kol1);
				wiersz.set('vendor_name',kol2);
				wiersz.set('responsible_sourcing',kol3);
				wiersz.set('responsible_sourcing_login',kol4);
			}
			else
			{
				temp = wiersz.get('vendor_no');
				if (temp=='')
				{
					wiersz.set('vendor_no',kol1);
				}
				temp = wiersz.get('vendor_name');
				if (temp=='')
				{
					wiersz.set('vendor_name',kol2);
				}
				temp = wiersz.get('responsible_sourcing');
				if (temp=='')
				{
					wiersz.set('responsible_sourcing',kol3);
					wiersz.set('responsible_sourcing_login',kol4);
				}

			}
		}
		tabela.save();
	}
	catch(oError)
	{
		tabela.rejectChanges();
		var komunikat = "An error has occured during adding data from Excel file to table. Check data in file.";
		alert(komunikat);
	}
	finally
	{
		tabela.autoSave = true;
	}
}

function eoShowJExcelImportPanelLogistic()
{
	var colsId = new Array();
	colsId[0]='new_item_no';
	colsId[1]='old_item_no';
	colsId[2]='belongs_to';
	colsId[3]='item_name';
	colsId[4]='new_item';
	colsId[5]='type_of_purchase';
	colsId[6]='obsolete';
	colsId[7]='part_type';
	colsId[8]='item_desc';
	colsId[9]='product_group';
	colsId[10]='new_amount';
	colsId[11]='revision';
	colsId[12]='new_price';
	colsId[13]='change_availibility';
	colsId[14]='availibility_date';
	colsId[15]='lead_time';
	colsId[16]='vendor_no';
	colsId[17]='vendor_name';
	colsId[18]='responsible_sourcing';
	colsId[19]='responsible_logistics';
	colsId[20]='stock_in_mau';
	colsId[21]='stock_value_in_mau';
	colsId[22]='stock_at_supplier';
	colsId[23]='stock_value_at_supplier';
	colsId[24]='obsolete_value';
	colsId[25]='stock_end_date';
	colsId[26]='influence_on_project';
	colsId[27]='influence_desc';
	colsId[28]='proposal';
	
	var colsMapping = new Array();
	colsMapping[0]='Item no';
	colsMapping[1]='Old item no';
	colsMapping[2]='Belongs to';
	colsMapping[3]='Item name';
	colsMapping[4]='New item';
	colsMapping[5]='Type of purchase';
	colsMapping[6]='To be obsolete';
	colsMapping[7]='Part type';
	colsMapping[8]='Item desc';
	colsMapping[9]='Product group';
	colsMapping[10]='New amount';
	colsMapping[11]='Revision';
	colsMapping[12]='New price';
	colsMapping[13]='Change availibility';
	colsMapping[14]='Availibility date';
	colsMapping[15]='Lead Time';
	colsMapping[16]='Vendor no';
	colsMapping[17]='Vendor name';
	colsMapping[18]='Responsible - Sourcing';
	colsMapping[19]='Responsible - Logistic';
	colsMapping[20]='Stock in MAU';
	colsMapping[21]='Stock value in MAU';
	colsMapping[22]='Stock at sup.';
	colsMapping[23]='Stock value at sup.';
	colsMapping[24]='Obsolete value';
	colsMapping[25]='Stock end date';
	colsMapping[26]='Influence on project';
	colsMapping[27]='Influence desc';
	colsMapping[28]='Proposal';	
	var fs;
	fs = new Ext.FormPanel({
		fileUpload: true, //(1)
		width: '100%',
		frame: true,
		//title: 'File Upload',
		bodyStyle: 'padding: 10px 10px 0 10px;',
		labelWidth: 100,
		items: 
			[
			    {
					xtype: 'fileuploadfield',
					emptyText: 'Choose xlsx file...',
					fieldLabel: 'Plik xlsx',
					name: 'file', //(2)
					buttonText: 'Choose file...',
					width: '100%',
					autowidth: true,
					id:'Xls_panel_label'
				},
			    {
			        xtype      : 'checkbox',
			        fieldLabel : "Keep current values",
			        boxLabel   : '',
			        inputValue : '',
			        id	   	   : 'Xls_panel_checkbox',
			        checked	   : false
			      }
			      
			],
			buttons: [
            {
				text: 'Enter',
				handler: function()
				{
					var v = Ext.get('Xls_panel_label').getValue();
					var checkboxVal = Ext.getCmp('Xls_panel_checkbox').getValue();

					if(v=='Choose xlsx file...' || v=='')
					{
							Ext.Msg.show({
								title: 'Info',
								msg: 'Choose file first.',
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.INFO
							});
					}
					else
					{
						fs.getForm().submit(
						{
							url: 'com.plusmpm.servlet.extension.P0045.eo.P0045LoadDataFromXlsx.customServlet?cols=' + colsMapping.join(";")+"&colIds="+colsId.join(";"),
							waitMsg: 'File Processing...',
							waitTitle : 'Please wait',

							success: function(form, action) //(3)
							{
							P0045eoSetDataInTableLogistic( action.result.data, !checkboxVal);
								win.close();
							},
							failure: function(form, action) //(4)action.result
							{
								Ext.Msg.alert('Error', 'An error has occured during file processing. Check file extension and columns names in xlsx file.');
							}
						});
					}
				}
			}]
		});
		
	win = new Ext.Window({
				layout: 'fit',
				height: 160,
				width: 530,
				//autoheight: true,
				//autowidth: true,
				shadow: false,
				closable: true,
				constrain: true,
				title: 'Xlsx Load',
				draggable: true,
				plain: true,
				resizable: false,
				modal: true,
				items: fs
            });
        
    win.show(this);
}

function P0045eoSetDataInTableLogistic(data,replaceCurrentValues)
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	tabela.autoSave=false;
	
	var jsonData = Ext.util.JSON.decode(data);
	var jr = jsonData.records;
	var wielkoscTablicy=jr.length;
	var wielkoscTabeli = tabela.getCount();
	
	if (wielkoscTablicy!=wielkoscTabeli)
	{
		alert("Number of rows in excel file ("+wielkoscTablicy+") doesn't match number of rows in table ("+wielkoscTabeli+"). File cannot be imported.");
		return;
	}
	
	try
	{
		tabela.autoSave = false;
		for (var i=0;i<wielkoscTablicy;i++)
		{
			var wiersz = tabela.getAt(i);
			var kol0 = jr[i].stock_in_mau;
			var kol1 = jr[i].stock_value_in_mau;
			var kol2 = jr[i].stock_at_supplier;
			var kol3 = jr[i].stock_value_at_supplier;
			var kol4 = jr[i].obsolete_value;
			var kol5 = jr[i].stock_end_date;
			var kol6 = jr[i].influence_on_project;
			var kol7 = jr[i].influence_desc;
			var kol8 = jr[i].proposal;
			if (replaceCurrentValues)
			{
				wiersz.set('stock_in_mau',kol0);
				wiersz.set('stock_value_in_mau',kol1);
				wiersz.set('stock_at_supplier',kol2);
				wiersz.set('stock_value_at_supplier',kol3);
				wiersz.set('obsolete_value',kol4);
				if (kol5!="")
					wiersz.set('stock_end_date',P0045ExcelDateToJSDate(kol5));
				wiersz.set('influence_on_project',kol6);
				wiersz.set('influence_desc',kol7);
				wiersz.set('proposal',kol8);
			}
			else
			{
				temp = wiersz.get('stock_in_mau');
				if (temp=='')
				{
					wiersz.set('stock_in_mau',kol0);
				}
				temp = wiersz.get('stock_value_in_mau');
				if (temp=='')
				{
					wiersz.set('stock_value_in_mau',kol1);
				}
				temp = wiersz.get('stock_at_supplier');
				if (temp=='')
				{
					wiersz.set('stock_at_supplier',kol2);
				}
				temp = wiersz.get('stock_value_at_supplier');
				if (temp=='')
				{
					wiersz.set('stock_value_at_supplier',kol3);
				}
				temp = wiersz.get('obsolete_value');
				if (temp=='')
				{
					wiersz.set('obsolete_value',kol4);
				}
				temp = wiersz.get('stock_end_date');
				if (temp=='')
				{
					if (kol5!="")
						wiersz.set('stock_end_date',P0045ExcelDateToJSDate(kol5));
				}
				temp = wiersz.get('influence_on_project');
				if (temp=='')
				{
					wiersz.set('influence_on_project',kol6);
				}
				temp = wiersz.get('influence_desc');
				if (temp=='')
				{
					wiersz.set('influence_desc',kol7);
				}
				temp = wiersz.get('proposal');
				if (temp=='')
				{
					wiersz.set('proposal',kol8);
				}
			}
		}
		tabela.save();
	}
	catch(oError)
	{
		tabela.rejectChanges();
		var komunikat = "An error has occured during adding data from Excel file to table. Check data in file.";
		alert(komunikat);
	}
	finally
	{
		tabela.autoSave = true;
	}
}

function eoShowJExcelImportPanelDelegateLogistic()
{
	var colsId = new Array();
	colsId[0]='new_item_no';
	colsId[1]='old_item_no';
	colsId[2]='belongs_to';
	colsId[3]='item_name';
	colsId[4]='new_item';
	colsId[5]='type_of_purchase';
	colsId[6]='obsolete';
	colsId[7]='part_type';
	colsId[8]='item_desc';
	colsId[9]='product_group';
	colsId[10]='new_amount';
	colsId[11]='revision';
	colsId[12]='new_price';
	colsId[13]='change_availibility';
	colsId[14]='availibility_date';
	colsId[15]='lead_time';
	colsId[16]='vendor_no';
	colsId[17]='vendor_name';
	colsId[18]='responsible_sourcing';
	colsId[19]='responsible_logistics';
	colsId[20]='row_comment';
	colsId[21]='influence_on_project';
	colsId[22]='influence_desc';
	
	var colsMapping = new Array();
	colsMapping[0]='Item no';
	colsMapping[1]='Old item no';
	colsMapping[2]='Belongs to';
	colsMapping[3]='Item name';
	colsMapping[4]='New item';
	colsMapping[5]='Type of purchase';
	colsMapping[6]='To be obsolete';
	colsMapping[7]='Part type';
	colsMapping[8]='Item desc';
	colsMapping[9]='Product group';
	colsMapping[10]='New amount';
	colsMapping[11]='Revision';
	colsMapping[12]='New price';
	colsMapping[13]='Change availibility';
	colsMapping[14]='Availibility date';
	colsMapping[15]='Lead Time';
	colsMapping[16]='Vendor no';
	colsMapping[17]='Vendor name';
	colsMapping[18]='Responsible - Sourcing';
	colsMapping[19]='Responsible - Logistic';
	colsMapping[20]='Comment';
	colsMapping[21]='Influence on project';
	colsMapping[22]='Influence desc';
	
	var fs;
	fs = new Ext.FormPanel({
		fileUpload: true, //(1)
		width: '100%',
		frame: true,
		//title: 'File Upload',
		bodyStyle: 'padding: 10px 10px 0 10px;',
		labelWidth: 100,
		items: 
			[
			    {
					xtype: 'fileuploadfield',
					emptyText: 'Choose xlsx file...',
					fieldLabel: 'Plik xlsx',
					name: 'file', //(2)
					buttonText: 'Choose file...',
					width: '100%',
					autowidth: true,
					id:'Xls_panel_label'
				},
			    {
			        xtype      : 'checkbox',
			        fieldLabel : "Keep current values",
			        boxLabel   : '',
			        inputValue : '',
			        id	   	   : 'Xls_panel_checkbox',
			        checked	   : false
			      }
			      
			],
			buttons: [
            {
				text: 'Enter',
				handler: function()
				{
					var v = Ext.get('Xls_panel_label').getValue();
					var checkboxVal = Ext.getCmp('Xls_panel_checkbox').getValue();

					if(v=='Choose xlsx file...' || v=='')
					{
							Ext.Msg.show({
								title: 'Info',
								msg: 'Choose file first.',
								buttons: Ext.Msg.OK,
								icon: Ext.Msg.INFO
							});
					}
					else
					{
						fs.getForm().submit(
						{
							url: 'com.plusmpm.servlet.extension.P0045.eo.P0045LoadDataFromXlsx.customServlet?cols=' + colsMapping.join(";")+"&colIds="+colsId.join(";"),
							waitMsg: 'File Processing...',
							waitTitle : 'Please wait',

							success: function(form, action) //(3)
							{
							P0045eoSetDataInTableDelegateLogistic( action.result.data, !checkboxVal);
								win.close();
							},
							failure: function(form, action) //(4)action.result
							{
								Ext.Msg.alert('Error', 'An error has occured during file processing. Check file extension and columns names in xlsx file.');
							}
						});
					}
				}
			}]
		});
		
	win = new Ext.Window({
				layout: 'fit',
				height: 160,
				width: 530,
				//autoheight: true,
				//autowidth: true,
				shadow: false,
				closable: true,
				constrain: true,
				title: 'Xlsx Load',
				draggable: true,
				plain: true,
				resizable: false,
				modal: true,
				items: fs
            });
        
    win.show(this);
}

function P0045eoSetDataInTableDelegateLogistic(data,replaceCurrentValues)
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	tabela.autoSave=false;
	
	var jsonData = Ext.util.JSON.decode(data);
	var jr = jsonData.records;
	var wielkoscTablicy=jr.length;
	var wielkoscTabeli = tabela.getCount();
	
	if (wielkoscTablicy!=wielkoscTabeli)
	{
		alert("Number of rows in excel file ("+wielkoscTablicy+") doesn't match number of rows in table ("+wielkoscTabeli+"). File cannot be imported.");
		return;
	}
	
	try
	{
		tabela.autoSave = false;
		for (var i=0;i<wielkoscTablicy;i++)
		{
			var wiersz = tabela.getAt(i);
			var logistic_needed = wiersz.get('logistic_needed');
			if (logistic_needed=='' || logistic_needed=='No')
			{
				continue;
			}
			var kol0 = jr[i].responsible_logistics;
			var kol1 = jr[i].responsible_logistics_login;
			var kol2 = jr[i].row_comment;
			var kol3 = jr[i].influence_on_project;
			var kol4 = jr[i].influence_desc;
			
			if (replaceCurrentValues)
			{
				wiersz.set('responsible_logistics',kol0);
				wiersz.set('responsible_logistics_login',kol1);
				wiersz.set('row_comment',kol2);
				wiersz.set('influence_on_project',kol3);
				wiersz.set('influence_desc',kol4);
			}
			else
			{
				temp = wiersz.get('responsible_logistics');
				if (temp=='')
				{
					wiersz.set('responsible_logistics',kol0);
					wiersz.set('responsible_logistics_login',kol1);
				}

				temp = wiersz.get('row_comment');
				if (temp=='')
				{
					wiersz.set('row_comment',kol2);
				}
				temp = wiersz.get('influence_on_project');
				if (temp=='')
				{
					wiersz.set('influence_on_project',kol3);
				}
				temp = wiersz.get('influence_desc');
				if (temp=='')
				{
					wiersz.set('influence_desc',kol4);
				}
			}
		}
		tabela.save();
	}
	catch(oError)
	{
		tabela.rejectChanges();
		var komunikat = "An error has occured during adding data from Excel file to table. Check data in file.";
		alert(komunikat);
	}
	finally
	{
		tabela.autoSave = true;
	}
}

function P0045ExcelDateToJSDate(excelDate)
{
	var returnDate;
	if (excelDate.length==10)
		return excelDate;
	try
	{
		var temp = parseInt(excelDate);
		temp = (temp - 25569.0) * 60 * 24 * 60 * 1000;
		var tempDate=new Date(temp);
		returnDate = tempDate.format("Y-m-d");
	}
	catch (oError)
	{
	}
	return returnDate;
}

function P0045eoTableItemsAdd(oStore,rRecords,iIndex)
{
    try
    {
        // zawieszam wyzwalanie zdarzeń, ponieważ jestem w zdarzeniu
        // nie chcemy wyzwalania zdarzeń z wnętrza zdarzeń
    	oStore.suspendEvents(false);
		for ( var i=0; i < rRecords.length; i++)
	    {
			var temp = rRecords[i].get('new_item');
			if (temp==null || temp=='')
				rRecords[i].set('new_item',"No");
			temp = rRecords[i].get('obsolete');
			if (temp==null || temp=='')
				rRecords[i].set('obsolete',"No");
			temp = rRecords[i].get('sourcing_needed');
			if (temp==null || temp=='')
				rRecords[i].set('sourcing_needed',"No");
			temp = rRecords[i].get('logistic_needed');
			if (temp==null || temp=='')
				rRecords[i].set('logistic_needed',"Yes");
			temp = rRecords[i].get('sd_needed');
			if (temp==null || temp=='')
				rRecords[i].set('sd_needed',"No");
			temp = rRecords[i].get('critical_item');
			if( temp!=undefined && (temp==null || temp==''))
				rRecords[i].set('critical_item',"No");
			
	    	//rRecords[i].commit();
	    }
    }
    finally
    {
        // przywracam zdarzenia
    	oStore.resumeEvents();
    }
    
}

function eoConsultationAnswer()
{
	var commentAdd = checkChangesInComments(activityId,processId,sTaskUserName);
	if (commentAdd=='FALSE')
	{
		alert("You must add a comment before taking this action.");
		return false;
	}
	
	return true;
}

function eoConsultationConsult()
{
	var commentAdd = checkChangesInComments(activityId,processId,sTaskUserName);
	if (commentAdd=='FALSE')
	{
		alert("You must add a comment before taking this action.");
		return false;
	}
	
	var consultant = document.getElementById('consultant').value;
	var consultant_login = document.getElementById('consultant_login').value;
	if (consultant_login=="" || consultant=="" || consultant_login==sTaskUserName )
	{
		alert("You must choose Consultant before taking this action.");
		return false;
	}
	
	return true;
}

function eoCheckPOTable()
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_1_JsonStore");
	var process_type = clientGetRadioValue('process_type');

	// jesli lokalizacja to PO nie jest wymagane
	if( !(process_type!=undefined && process_type=='Localization'))
	{
		if (tabela!=null)
		{
			var iloscWierszy = tabela.getCount();
			if (iloscWierszy==0)
			{
				alert("Add at least one row in 'PO numbers' table.");
				return false;
			} //end_if
			
			for (var i=0;i<iloscWierszy;i++)
			{
				var wiersz = tabela.getAt(i);
				var po_number = wiersz.get('po_number');
				var po_influence_on_project = wiersz.get('po_influence_on_project');
				var po_influence_desc = wiersz.get('po_influence_desc');
				var po_comment = wiersz.get('po_comment');
				if (po_number=='')
				{
					alert("Please fill up 'PO number' column in line "+(i+1));
					return false;
				}
				else if (po_influence_on_project=='' && processId.indexOf('sub_logi')>0)
				{
					alert("Please fill up 'PO influence on project' column in line "+(i+1));
					return false;
				}
				else if (po_influence_desc=='' && po_influence_on_project!='No' && processId.indexOf('sub_logi')>0) //WYMAGALNOŚĆ WARUNKOWA
				{
					alert("Please fill up 'PO influence desc' column in line "+(i+1));
					return false;
				}
			} //end_for
		}
		else
		{
			var po = document.getElementById('po_number').value;
			if (po=='')
			{
				alert('Please fill up <PO number>.');
				return false;
			}
		}
	}
	
	return true;
}

function eoPOTableBeforewrite(store, action, record, options, arg)
{
	store.suspendEvents(false);
	record.set('po_row_changed','yes');
	store.resumeEvents();
}

function Post_delivery_notification_Confirm()
{
	return true;
}

function Sourcing_development_notification_Confirm()
{
	return true;
}



//// ZMIANY DLA LOKALIZACJI

function P0045eoRmBttnColorLine(oEditorGridPanel)
{
	//usuwanie buttonow
	oEditorGridPanel.keys=null;
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[1]);
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[2]);
	
	//kolorowanie linii
	P0045eoKolorowanieLinii(oEditorGridPanel)
}

function eoBeforeRender_log(oEditorGridPanel)
{
	oEditorGridPanel.keys=null;
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
	oEditorGridPanel.bottomToolbar.remove(oEditorGridPanel.bottomToolbar.items.items[0]);
}

function eoBeforeEdit_log(obj)
{
	// jesli proces jest na innym etapie to niemozna go edytowac
	var item_status =  obj.record.get("item_status");
	
	if(obj.record.get('logistic_needed')=="No")
	{
		alert("Logistic is not needed for this part type");
		obj.cancel=true;
	}
	else if(item_status!="")
	{
		if(item_status.indexOf("Delegate logistics")<0)
			obj.cancel=true;
	}

}
		
function P0045eoKolorowanieLinii_log(oEditorGridPanel)
{
//	if(oEditorGridPanel.store.getCount()<10)
//		oEditorGridPanel.autoHeight = true;	
	var view = oEditorGridPanel.getView();
	var store = oEditorGridPanel.getStore();
	var iloscWierszy = store.getCount();

	for (var q=0;q<iloscWierszy; q++)
	{
		var wiersz = store.getAt(q);
		var item_status = wiersz.get('item_status');
		if(item_status=="Logistics finished" )
		{
			view.addRowClass(q, 'eo_item_finished');
		}
		else if(item_status.indexOf('rejected') > 0 )
		{
			view.addRowClass(q, 'eo_item_rejected');
		}
		else if((item_status!="" && item_status!="Delegate logistics"))
		{
			view.addRowClass(q, 'eo_item_inactive');
		}
	}
	var title = "Items&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #CCCCCC; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - inactive items &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #FFFFFF; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - items to process";
	oEditorGridPanel.setTitle(title);

}

var global_process_type = "";

function ModifyFormForLocalization()
{	
	var pierwszyRbtn = document.getElementById('process_type');
	pierwszyRbtn.onclick=manualLocUstawienieWidocznosciPol;
	var drugiRbtn = pierwszyRbtn.nextSibling.nextSibling;
	drugiRbtn.onclick=manualLocUstawienieWidocznosciPol;
	
	global_process_type = clientGetRadioValue('process_type');
	setTimeout("LocUstawienieWidocznosciPol()",0);
}

 
function manualLocUstawienieWidocznosciPol()
{
	
	var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
	
	if(store.getCount()>0)
	{
		alert("You can not change the Process type, first item has been added to the table.");		
		var pierwszyRbtn = document.getElementById('process_type');
		var drugiRbtn = pierwszyRbtn.nextSibling.nextSibling;
		if(global_process_type=="EO")
		{
			pierwszyRbtn.checked=true;
			drugiRbtn.checked=false;
		}
		else
		{
			pierwszyRbtn.checked=false;
			drugiRbtn.checked=true;	
		}
	}
	else
		LocUstawienieWidocznosciPol();
}

function LocUstawienieWidocznosciPol(grid)
{
	var process_type = clientGetRadioValue('process_type');
	global_process_type = process_type;
	if(process_type!=undefined && process_type=='Localization')
	{
		var varToHideList = new Array();
		
		varToHideList[varToHideList.length]='eo_number';
		varToHideList[varToHideList.length]='eo_class';
		varToHideList[varToHideList.length]='eo_class_desc';
		
		if( varToHideList.length > 0 ){
			clientHideVar(varToHideList, null);
		}	
		
		var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
		var gridDiv = document.getElementById(store.storeId.replace('_JsonStore', ''));
		grid = Ext.getCmp(gridDiv.firstChild.id);
			    
	    var columnToHide = new Array();		
	    columnToHide[columnToHide.length]='old_item_no';
	    columnToHide[columnToHide.length]='belongs_to';		
	    columnToHide[columnToHide.length]='new_item';
		columnToHide[columnToHide.length]='type_of_purchase';
	    columnToHide[columnToHide.length]='obsolete';
	    columnToHide[columnToHide.length]='new_amount';
	    columnToHide[columnToHide.length]='sourcing_needed';		
	    columnToHide[columnToHide.length]='logistic_needed';
	    
	    clientHideColumns(grid, columnToHide);	
	    
	    //zmieniam dane w tabeli dynamicznej 
	    store.each(function(oRs){
	    	try
	    	{
	    		store.autoSave = false;		
		    	oRs.set('logistic_needed',"No");
		    	oRs.set('sourcing_needed',"No");
		    	oRs.set('sd_needed',"No");
		    	oRs.set('new_item',"Yes");
		    	//oRs.commit();
		    	store.save();
	    	}
	    	catch(ex)
	    	{
	    		
	    	}
	    	finally
	    	{
		    	store.autoSave = true;			    		
	    	}
	    });
	    
	}
	else
	{		
		var varToShowList = new Array();
		
		varToShowList[varToShowList.length]='eo_number';
		varToShowList[varToShowList.length]='eo_class';
		varToShowList[varToShowList.length]='eo_class_desc';
		
		if( varToShowList.length > 0 ){
			clientShowVar(varToShowList, null);
		}	
		
		//odkrywanie kolumn 
		var store = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");
		var gridDiv = document.getElementById(store.storeId.replace('_JsonStore', ''));
	    var grid = Ext.getCmp(gridDiv.firstChild.id);
	 
	    var columnToShow = new Array();		
	    columnToShow[columnToShow.length]='old_item_no';
	    columnToShow[columnToShow.length]='belongs_to';		
	    columnToShow[columnToShow.length]='new_item';
		columnToShow[columnToShow.length]='type_of_purchase';
	    columnToShow[columnToShow.length]='obsolete';
	    columnToShow[columnToShow.length]='new_amount';
	    columnToShow[columnToShow.length]='sourcing_needed';		
	    columnToShow[columnToShow.length]='logistic_needed';
	    
	    clientShowColumns(grid, columnToShow);	  
	}
}

function clientHideColumns(grid, columns)
{
	if (grid != null) 
	{    	
		// ukrywanie kolumn
		for(var i=0; i<columns.length; i++)
		{
			var index = grid.getColumnModel().getIndexById('dt_col_id_'+columns[i]);
			//oDataDynamicTableDefinition_0.jsonData.columns[index].hidden = true;		
			grid.getColumnModel().setHidden(index, true);
		}

		// odswiezenie widoku
		 try
		 {
			 grid.suspendEvents(false);

			 grid.getView().fitColumns(false);
			 grid.getView().refresh(true);
		 }
		 catch(ex)
		 {
			 
		 }
		 finally
		 {
			 //wylaczam automatyczne dopasowywanie szerokosci kolumn
			 grid.getView().forceFit = false;
			 //usuwam ciasteczko zapisanego stanu
			 grid.mpm_clearState();
			 //odwieszam zdarzenia po zakonczeniu resetowania
			 grid.resumeEvents();
		 } 
		
	}
}

function clientShowColumns(grid, columns)
{
	if (grid != null) 
	{  
		//odkrywanie kolumn
		for(var i=0; i<columns.length; i++)
		{
			var index = grid.getColumnModel().getIndexById('dt_col_id_'+columns[i]);
			//oDataDynamicTableDefinition_0.jsonData.columns[index].hidden = false;	
			grid.getColumnModel().setHidden(index, false);
		}

	
		try
		{
			grid.suspendEvents(false);

			grid.getView().fitColumns(false);
			grid.getView().refresh(true);
		}
		catch(ex)
		{
			alert(ex);
		}
		finally
		{
			 //wylaczam automatyczne dopasowywanie szerokosci kolumn
			grid.getView().forceFit = false;
			 //usuwam ciasteczko zapisanego stanu
			grid.mpm_clearState();
			 //odwieszam zdarzenia po zakonczeniu resetowania
			grid.resumeEvents();
		} 
		
	}
}

function clientGetRadioValue(radioId)
{
	var radioValue = null;
	try
	{
		var radio = document.getElementById(radioId);
		var radioTab = document.getElementsByName(radio.name);
	
		for(i=0; i<radioTab.length;i++)
		{
			var item = radioTab.item(i);
			
			//dla zmiennej nieedytowalnej, hidden określa czy checkbox jest zaznaczony.
			if(item.type == "hidden" || item.type == "radio" && item.checked)
			{
				radioValue = item.value;
				break;
			}
		}
	}catch(e)
	{
		
	}
	
	return radioValue;
}


function clientHideVar(idVarList, tableNameList)
{
	try
	{	
		var table = document.getElementById('taskpanel').lastChild;
		
		if(table==null) 
			return false;
		
		//Jezeli posiadamy zmienna table to zaczynamy uktywac:
		if(idVarList!=null)
		{
			for(i=0; i<idVarList.length; i++)
			{
				var var1 = document.getElementById(idVarList[i]);
				if(var1!=null)
				{
					var rowIndexVar= -1;
					if(var1.type=='radio' || var1.type=='hidden')
					{
						if( var1.type=='hidden')// radiobutton nieedytowlany
						{
							var parent = var1.parentNode;
							var childParent = parent.children;
							//if(childParent.length==1)
							//	break;
						}
						rowIndexVar= var1.parentNode.parentNode.rowIndex;
					}
					else
					{
						rowIndexVar = var1.parentNode.parentNode.parentNode.rowIndex;
						if (rowIndexVar==null)
							rowIndexVar=var1.parentNode.parentNode.rowIndex;
					}
					if(rowIndexVar!=null)
					{
						var row = table.rows[rowIndexVar];
						row.style.display = 'none';
					}
				}
			}
		}
		
		if(tableNameList!=null)
		{
			for(j=0; j<tableNameList.length; j++)
			{
				var tableName = tableNameList[j];
				
				if(tableName.indexOf('data_dynamic_tabel_div_')>-1)
				{
					var grid = document.getElementById(tableName);
					if(grid!=null)
					{
						var rowIndexTab= grid.parentNode.parentNode.rowIndex;
						var row = table.rows[rowIndexTab];
						row.style.display = 'none';
					}
				}else
				{
					for(i=0; i<100; i++)
					{
						var grid = document.getElementById('data_dynamic_tabel_div_' + i);
						if(grid==null) 
							break;
						else
						{
							var gridExt = Ext.getCmp(grid.firstChild.id);
							if(gridExt.title==tableName)
							{
								var rowIndexTab= grid.parentNode.parentNode.rowIndex;
								
								if(rowIndexTab!=null)
								{
									var row = table.rows[rowIndexTab];
									row.style.display = 'none';
								}
							}
						}
					}
				}
			}
		}
	
		if(formPanel)
			formPanel.recalculateHeights();
	}catch (oError) {
		return false;
	}
	return true;
}

function clientShowVar(idVarList, tableNameList)
{
	try {
		var table = document.getElementById('taskpanel').lastChild;
		
		if(table==null) 
			return false;
		
		//Jezeli posiadamy zmienna table to zaczynamy pokazywac:
		if(idVarList!=null)
		{
			for(i=0; i<idVarList.length; i++)
			{
				var var1 = document.getElementById(idVarList[i]);
				if(var1!=null)
				{
					if(var1.type=='radio' || var1.type=='hidden')
					{
						if( var1.type=='hidden') 	// radiobutton nieedytowlany
						{
							var parent = var1.parentNode;
							var childParent = parent.children;
							if(childParent.length==1)
								break;
						}
						rowIndexVar= var1.parentNode.parentNode.rowIndex;
					}
					else
					{
						rowIndexVar = var1.parentNode.parentNode.parentNode.rowIndex;
						if (rowIndexVar==null)
							rowIndexVar=var1.parentNode.parentNode.rowIndex;
					}
					if(rowIndexVar!=null)
					{
						var row = table.rows[rowIndexVar];
						row.style.display = '';
					}
				}
			}
		}
		
		var defaultHeightTable=264;
		if(tableNameList!=null)
		{
			for(j=0; j<tableNameList.length; j++)
			{
				var tableName = tableNameList[j];

				if(tableName.indexOf('data_dynamic_tabel_div_')>-1)
				{
					var grid = document.getElementById(tableName);
					if(grid!=null)
					{
						var gridExt = Ext.getCmp(grid.firstChild.id);

						gridExt.setHeight(defaultHeightTable);
						
						var rowIndexTab= grid.parentNode.parentNode.rowIndex;
						var row = table.rows[rowIndexTab];
						row.style.display = '';
						gridExt.onRefresh(null, null, gridExt, null);
						//gridExt.getView().refresh(true);

					}

				}else
				{
					for(i=0; i<100; i++)
					{
						var grid = document.getElementById('data_dynamic_tabel_div_' + i);
						if(grid==null) 
							break;
						else
						{
							var gridExt = Ext.getCmp(grid.firstChild.id);
							if(gridExt.title==tableName)
							{
								gridExt.setHeight(defaultHeightTable);
								var rowIndexTab= grid.parentNode.parentNode.rowIndex;
								if(rowIndexTab!=null)
								{
									var row = table.rows[rowIndexTab];
									row.style.display = '';
									gridExt.onRefresh(null, null, gridExt, null);
									//gridExt.getView().refresh(true);
								}
							}
						}
					}
				}
			}
		}
	
		if(formPanel)
			formPanel.recalculateHeights();
		
	}catch (oError) {
		return false;
	}
	return true;
}

function TabItemsBeforewrite(oStore, sAction, rRecords, oOptions, oArg)
{
	
	try
	{		
		oStore.autoSave = false;		
    	//oStore.suspendEvents(false);
		
		var process_type = clientGetRadioValue('process_type');
		if(process_type!=undefined && process_type=='Localization')
		{
			if(Ext.isArray(rRecords) === false)
			{
				rRecords.set('logistic_needed',"No");
				rRecords.set('sourcing_needed',"No");
				rRecords.set('new_item',"Yes");
				
				//oStore.commitChanges();
				//oStore.save();
			}
			else
			{
		    	for ( var i=0; i < rRecords.length; i++)
			    {			
					// usatwiam lg needed na nie
					rRecords[i].set('logistic_needed',"No");
					rRecords[i].set('sourcing_needed',"No");
					rRecords[i].set('new_item',"Yes");
				}	
			}
	    }	
	
	}
	catch(oError)
	{
	    alert(oError);
		return false; 
	}
	finally
	{
		//oStore.resumeEvents();
		oStore.autoSave = true;
	}
	return true;
}

function Logistics_Reject()
{
	return confirm("Please confirm that you want to reject this item.");
}

function Sourcing_Reject()
{
	return confirm("Please confirm that you want to reject this item.");
}

function eo_logistics_end_process()
{
	return true;
}

function eo_sourcing_end_process()
{
	return true;
}

function Delegate_logistic_priorities_Send()
{
	var tabela = Ext.StoreMgr.get("data_dynamic_tabel_div_0_JsonStore");

	if (tabela!=null)
	{
		var iloscWierszy = tabela.getCount();
		if (iloscWierszy==0)
		{
			alert("Add at least one row in 'PO numbers' table.");
			return false;
		} //end_if
			
		for (var i=0;i<iloscWierszy;i++)
		{
			var wiersz = tabela.getAt(i);
			var when_needed = wiersz.get('when_needed');
			var type_of_purchase = wiersz.get('type_of_purchase');
			var logistic_needed = wiersz.get('logistic_needed');
			var new_item = wiersz.get('new_item');			
			
			if ((when_needed==null || when_needed=='') && type_of_purchase=='Purchase' && (logistic_needed=='Yes' || new_item=='Yes') )
			{
				alert("Please fill up 'When needed in MAU' column in line "+(i+1));
				return false;
			}
		}
	}
	
	return true;
}

function P0045LocKolorowanieLinii(oEditorGridPanel)
{	
	var process_type = clientGetRadioValue('process_type');
	
	var view = oEditorGridPanel.getView();
	var store = oEditorGridPanel.getStore();
	var iloscWierszy = store.getCount();

	for (var q=0;q<iloscWierszy; q++)
	{
		var wiersz = store.getAt(q);
		try
		{
			var item_status = wiersz.get('item_status');
			var critical_item = wiersz.get('critical_item');
			if(item_status!=undefined && item_status.indexOf('rejected') > 0 )
			{
				view.addRowClass(q, 'eo_item_rejected');
			}						
			else if (critical_item!=undefined && critical_item=="Yes")
			{
				view.addRowClass(q, 'eo_item_critical');
			}
		}
		catch(ex)
		{
			
		}
	}
	var title = "Items&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #FF99CC; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - Critical items &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<div style=\"display: inline; background-color: #FFFFFF; border: 1px solid #000000\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</div> - other items";
	//oEditorGridPanel.setTitle(title);	
}